% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transtree.R
\name{transtree}
\alias{transtree}
\title{Create a consensus transmission tree.}
\usage{
transtree(phybreak.object, method = c("count", "edmonds", "mpc", "mtcc"),
  samplesize = Inf, infector.name = TRUE, support = c("proportion",
  "count"), infection.times = c("all", "infector", "infector.sd"),
  time.quantiles = c(0.025, 0.5, 0.975), phylo.class = FALSE)
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{method}{The method used to create the tree (see details).}

\item{samplesize}{The number of posterior samples that is used, taken from the tail.}

\item{infector.name}{Whether to return the infector names, or the position in the vector of hosts.}

\item{support}{Whether to return the support (= posterior probability) for each infector as a \code{"proportion"} 
or as a \code{"count"} of posterior trees in which that transmission link or transmission cluster is present.}

\item{infection.times}{Whether to base the summary infection times on \code{"all"} samples, or only on samples 
in which the \code{"infector"} was the same as in the consensus tree. A third option is \code{"infector.sd"}, 
in which case only posterior trees with the same infector or transmission cluster as in the consensus tree 
were used to calculate a mean and standard deviation. In that case and if \code{method = "mpc"} or \code{method = "mtcc"},
also the infection times in the first sampled tree with consensus tree topology are given.}

\item{time.quantiles}{Used only if \code{infection.times = "all"} or \code{"infector"}.}

\item{phylo.class}{Whether to return an object of class \code{"phylo"}, in which case a single tree 
(\code{"mpc"} or \code{"mtcc"}) from the posterior is returned (not with summary infection times).}
}
\value{
If \code{phylo.class = FALSE}, a \code{data.frame} with per item (=host) its infector and support per 
  infector (or cluster), and summary infection times. If \code{phylo.class = TRUE}, a class \code{"phylo"} object, a 
  single tree (\code{"mpc"} or \code{"mtcc"}) from the posterior is returned (not with summary infection times).
}
\description{
Various methods to create summary transmission trees from a \code{phybreak}-object containing posterior samples.
}
\details{
Four methods are supported for transmission tree reconstruction (who infected whom). 
\itemize{
  \item \code{"count"} gives the most frequent infector from the posterior samples. Note that this may 
    result in an improper tree (multiple roots and/or cycles). Support is measured by the frequency of the 
    infector in the posterior distribution.
  \item \code{"edmonds"} starts from the most frequent infector (method \code{"count"}), multiple roots and 
    cycles are removed by selecting one by one the next most frequent option that minimizes the loss in support 
    (\href{https://en.wikipedia.org/wiki/Edmonds\%27_algorithm}{Edmonds' algorithm}). Support is measured by the frequency of the infector in the posterior distribution.
  \item{"mpc"} gives the maximum parent credibility tree as described in \href{http://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1004613}{Hall et al (2015)}. This is the tree 
    in the set of posterior samples that has maximum support = product of frequencies among all posterior samples. 
    Support is measured by the frequency of the infector in the posterior distribution.
  \item{"mtcc"} gives the maximum transmission cluster credibility tree. This is equivalent to the maximum clade
    credibility (mcc) phylogenetic tree, with clusters defined as host + all progeny. Support is measured by the 
    frequency of the cluster in the posterior distribution.
}
}
\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

transtree(MCMCstate, method = "edmonds")
transtree(MCMCstate, method = "mpc", infection.times = "infector.sd")
plot(MCMCstate, plot.which = "mpc")
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
\references{
\href{http://dx.doi.org/10.1101/069195}{Klinkenberg et al, on biorXiv}.
}

