% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write.dendrogram}
\alias{write.dendrogram}
\title{Export a dendrogram object to text.}
\usage{
write.dendrogram(x, file = "", append = FALSE, edges = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{"dendrogram"}.}

\item{file}{a character string naming a file or connection to write the
output to. If no file path is specified or \code{file = ""} the result
is printed to the console.}

\item{append}{logical indicating whether the output should be
appended to the file. If \code{append = FALSE} the contents of the
file will be overwritten (the default setting).}

\item{edges}{logical indicating whether edge weights should be
included in the output string.}

\item{...}{further arguments to be passed to \code{format}. Used to
specify the numbering style of the edge weights (if edges = TRUE).}
}
\description{
This function writes a dendrogram object to Newick-style parenthetic text.
}
\examples{
  newick <- "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);"
  x <- read.dendrogram(text = newick)
  write.dendrogram(x, edges = TRUE)
}
\seealso{
\code{\link{read.dendrogram}} to create a \code{"dendrogram"}
  object from a text file.
  The \code{\link[ape]{write.tree}} function in the \code{\link[ape]{ape}}
  package performs a similar operation for \code{"phylo"}
  and \code{"multiPhylo"} objects.
}
