% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopath.R
\name{best}
\alias{best}
\title{Extract and estimate the best supported model from a phylogenetic path
analysis.}
\usage{
best(phylopath, ...)
}
\arguments{
\item{phylopath}{An object of class \code{phylopath}.}

\item{...}{Arguments to pass to \link[phylolm:phylolm]{phylolm::phylolm} and \link[phylolm:phyloglm]{phylolm::phyloglm}. If you specified
options in the original \link{phylo_path} call you don't need to specify them again.}
}
\value{
An object of class \code{fitted_DAG}.
}
\description{
Extract and estimate the best supported model from a phylogenetic path
analysis.
}
\examples{
  candidates <- list(A = DAG(LS ~ BM, NL ~ BM, DD ~ NL),
                     B = DAG(LS ~ BM, NL ~ LS, DD ~ NL))
  p <- phylo_path(candidates, rhino, rhino_tree)
  best_model <- best(p)
  # Print the best model to see coefficients, se and ci:
  best_model
  # Plot to show the weighted graph:
  plot(best_model)

}
