% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_range.R
\name{collapse_range}
\alias{collapse_range}
\title{Collapse nodes and ranges based on divergence times}
\usage{
collapse_range(
  x,
  tree,
  n,
  species = "species",
  grids = "grids",
  format = "wide"
)
}
\arguments{
\item{x}{A community matrix or data frame.}

\item{tree}{A phylogenetic tree.}

\item{n}{Time depth to slice the phylogenetic tree (often in millions of
years for dated trees).}

\item{species}{If \code{format =} \dQuote{long} (the default),
the column with the species name.}

\item{grids}{The column with the sites or grids if \code{format =}
\dQuote{long}.}

\item{format}{Format of the community composition data:
\dQuote{long} or \dQuote{wide} with species as columns and sites as rows.}
}
\value{
Two community data frames: the \code{collapsed community data} and
\code{original community data}
}
\description{
This function collapses nodes and geographic ranges based on species'
divergence times at various time depths.
}
\examples{
library(ape)
tr1 <- read.tree(text ="(((a:2,(b:1,c:1):1):1,d:3):1,e:4);")
com <- matrix(c(1,0,1,1,0,0,
                1,0,0,1,1,0,
                1,1,1,1,1,1,
                1,0,1,1,0,1,
                0,0,0,1,1,0), 6, 5,
              dimnames=list(paste0("g",1:6), tr1$tip.label))

collapse_range(com, tr1, n=1)
}
\references{
Daru, B.H., Farooq, H., Antonelli, A. & Faurby, S. (2020) Endemism
patterns are scale dependent. \emph{Nature Communications}
\strong{11}: 2115.
}
