##	
## Copyright 2009 Botond Sipos	
## See the package description for licensing information.	
##	

##
## CodonAlphabet
##
##########################################################################/** 
#
# @RdocClass CodonAlphabet
# 
# @title "The CodonAlphabet class"
# 
# \description{ 
#	This class implements codon alphabets and handles the translation of codons 
#	to their corresponding amino acids. Stop codons are excluded from the symbol set, 
#	thus the symbol set depends on the genetic code table.
#	The genetic code table can be specified through the \code{table.id} constructor parameter.
#
#	The available genetic code tables:
#	\preformatted{
#	1	Standard
#	2	Vertebrate Mitochondrial
#	3	Yeast Mitochondrial
#	4	Mold, Protozoan, and CoelenterateMitochondrial and Mycoplasma/Spiroplasma
#	5	Invertebrate Mitochondrial
#	6	Ciliate, Dasycladacean and Hexamita Nuclear	
#	9	Echinoderm Mitochondrial
#	10	Euplotid Nuclear
#	11	Bacterial
#	12	Alternative Yeast Nuclear
#	13	Ascidian Mitochondrial
#	14	Flatworm Mitochondrial
#	15	Blepharisma Nuclear
#	16	Chlorophycean Mitochondrial
#	21	Trematode Mitochondrial
#	22	Scenedesmus obliquus Mitochondrial
#	23	Thraustochytrium Mitochondrial
#	}
#
#	@classhierarchy
# }
#	
# @synopsis
#	
# \arguments{
# 	\item{table.id}{The identifier of the genetic code table.}
# 	\item{...}{Not used.}
#	}
# 
# \section{Fields and Methods}{ 
# 	@allmethods
# }
# 
# \examples{ 
#	# create a CodonAlphabet object
#	a<-CodonAlphabet(table.id=2)
#	# get object summary
#	summary(a)
# }
# 
# @author
#
# \seealso{ 
# 	@seeclass 
# }
# 
#*/###########################################################################
setConstructorS3(
  "CodonAlphabet",
  function(table.id=1,...){

# Genetic code tables, ripped from BioPerl. #

CODON.TABLES<-list(
	'1'=list(
		'name'='Standard',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='START'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='START'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'2'=list(
		'name'='Vertebrate Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='START'
			),
			'ATC'=list(
				aa='I',
				type='START'
			),
			'ATA'=list(
				aa='M',
				type='START'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='*',
				type='STOP'
			),
			'AGG'=list(
				aa='*',
				type='STOP'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='START'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'3'=list(
		'name'='Yeast Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='T',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='T',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='T',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='T',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='M',
				type='START'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'4'=list(
		'name'='Mold, Protozoan, and CoelenterateMitochondrial and Mycoplasma/Spiroplasma',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='START'
			),
			'TTG'=list(
				aa='L',
				type='START'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='START'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='START'
			),
			'ATC'=list(
				aa='I',
				type='START'
			),
			'ATA'=list(
				aa='I',
				type='START'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='START'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'5'=list(
		'name'='Invertebrate Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='START'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='START'
			),
			'ATC'=list(
				aa='I',
				type='START'
			),
			'ATA'=list(
				aa='M',
				type='START'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='S',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='START'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'6'=list(
		'name'='Ciliate, Dasycladacean and Hexamita Nuclear',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'TAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'9'=list(
		'name'='Echinoderm Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='S',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'10'=list(
		'name'='Euplotid Nuclear',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'11'=list(
		'name'='Bacterial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='START'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='START'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='START'
			),
			'ATC'=list(
				aa='I',
				type='START'
			),
			'ATA'=list(
				aa='I',
				type='START'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='START'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'12'=list(
		'name'='Alternative Yeast Nuclear',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='S',
				type='START'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'13'=list(
		'name'='Ascidian Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='M',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='G',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'14'=list(
		'name'='Flatworm Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='S',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'15'=list(
		'name'='Blepharisma Nuclear',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'16'=list(
		'name'='Chlorophycean Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'21'=list(
		'name'='Trematode Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='W',
				type='ORDINARY'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='M',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='S',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='START'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'22'=list(
		'name'='Scenedesmus obliquus Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='*',
				type='STOP'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='ORDINARY'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	),
	'23'=list(
		'name'='Thraustochytrium Mitochondrial',
		'trans'=list(
			'TTT'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTC'=list(
				aa='F',
				type='ORDINARY'
			),
			'TTA'=list(
				aa='*',
				type='STOP'
			),
			'TTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'TCT'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCC'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCA'=list(
				aa='S',
				type='ORDINARY'
			),
			'TCG'=list(
				aa='S',
				type='ORDINARY'
			),
			'TAT'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAC'=list(
				aa='Y',
				type='ORDINARY'
			),
			'TAA'=list(
				aa='*',
				type='STOP'
			),
			'TAG'=list(
				aa='*',
				type='STOP'
			),
			'TGT'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGC'=list(
				aa='C',
				type='ORDINARY'
			),
			'TGA'=list(
				aa='*',
				type='STOP'
			),
			'TGG'=list(
				aa='W',
				type='ORDINARY'
			),
			'CTT'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTC'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTA'=list(
				aa='L',
				type='ORDINARY'
			),
			'CTG'=list(
				aa='L',
				type='ORDINARY'
			),
			'CCT'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCC'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCA'=list(
				aa='P',
				type='ORDINARY'
			),
			'CCG'=list(
				aa='P',
				type='ORDINARY'
			),
			'CAT'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAC'=list(
				aa='H',
				type='ORDINARY'
			),
			'CAA'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CAG'=list(
				aa='Q',
				type='ORDINARY'
			),
			'CGT'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGC'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'CGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'ATT'=list(
				aa='I',
				type='START'
			),
			'ATC'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATA'=list(
				aa='I',
				type='ORDINARY'
			),
			'ATG'=list(
				aa='M',
				type='START'
			),
			'ACT'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACC'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACA'=list(
				aa='T',
				type='ORDINARY'
			),
			'ACG'=list(
				aa='T',
				type='ORDINARY'
			),
			'AAT'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAC'=list(
				aa='N',
				type='ORDINARY'
			),
			'AAA'=list(
				aa='K',
				type='ORDINARY'
			),
			'AAG'=list(
				aa='K',
				type='ORDINARY'
			),
			'AGT'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGC'=list(
				aa='S',
				type='ORDINARY'
			),
			'AGA'=list(
				aa='R',
				type='ORDINARY'
			),
			'AGG'=list(
				aa='R',
				type='ORDINARY'
			),
			'GTT'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTC'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTA'=list(
				aa='V',
				type='ORDINARY'
			),
			'GTG'=list(
				aa='V',
				type='START'
			),
			'GCT'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCC'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCA'=list(
				aa='A',
				type='ORDINARY'
			),
			'GCG'=list(
				aa='A',
				type='ORDINARY'
			),
			'GAT'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAC'=list(
				aa='D',
				type='ORDINARY'
			),
			'GAA'=list(
				aa='E',
				type='ORDINARY'
			),
			'GAG'=list(
				aa='E',
				type='ORDINARY'
			),
			'GGT'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGC'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGA'=list(
				aa='G',
				type='ORDINARY'
			),
			'GGG'=list(
				aa='G',
				type='ORDINARY'
			)
		)
	)
);

# end of genetic code tables #

	table.id<-as.character(table.id);

	# Figure out the symbols set by excluding stop codons:

	symbols<-character();

	for (codon in names(CODON.TABLES[[table.id]]$trans)) {

			if(CODON.TABLES[[table.id]]$trans[[codon]]$type != "STOP") {
				symbols<-c(symbols,codon);
			}
	}

	# Sort the codons alphabetically:
	symbols<-sort(symbols);

	this<-Alphabet(
		type=CODON.TABLES[[table.id]]$name,
		symbols=symbols
		);

	this<-extend(this,
		"CodonAlphabet",
		.table.id=table.id,
		.trans.table=CODON.TABLES[[table.id]]$trans,
		.is.codon.alphabet=TRUE
		);

		return(this);
  },
  enforceRCC=TRUE
);

##  
## Method: checkConsistency
##  
###########################################################################/**
#
# @RdocMethod	checkConsistency
# 
# @title "Check object consistency"
# 
# \description{ 
#		@get "title".
# } 
# 
# @synopsis 
#
# \arguments{ 
#       \item{this}{An object.} 
#       \item{...}{Not used.} 
# } 
# 
# 
# \value{ 
#		Returns an invisible TRUE if no inconsistencies found in the object, throws 
#		an error otherwise. 
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "checkConsistency",
  class="CodonAlphabet",
  function(
    this,
    ...
  ){ 

      wp<-this$writeProtected;
      if (wp) {
        this$writeProtected<-FALSE;
      }

      may.fail<-function(this) {

			if(!is.character(this$.table.id) | (length(this$.table.id) != 1) )	{
				throw(".table.id inconsistency!\n");
			}
			if(!is.list(this$.trans.table)){
				throw("Translation table is not a list!\n");
			}
			for (tmp in this$.trans.table){
					if (length(intersect(names(tmp),c("aa","type"))) != 2){
						throw("Translation table contains invalid entries!\n");
					}
			}

      }
      tryCatch(may.fail(this),finally=this$writeProtected<-wp);
      NextMethod();

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);


##  
## Method: getTableId
##  
###########################################################################/**
#
# @RdocMethod getTableId
# 
# @title "Get the genetic code id" 
# 
# \description{ 
#	@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
# 	\item{this}{A CodonAlphabet object.} 
# 	\item{...}{Not used.} 
# } 
# 
# \value{ 
# 	A numeric vector of length one.
# } 
# 
# \examples{
#	# create CodonAlphabet object
#	a<-CodonAlphabet()
#	# get genetic code id
#	getTableId(a)
#	# get genetic code id via virtual field
#	a$tableId
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "getTableId",
  class="CodonAlphabet",
  function(
    this,
    ...
  ){

		this$.table.id;

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: setTableId
##  
###########################################################################/**
#
# @RdocMethod setTableId
#
# @title "Forbidden action: setting the genetic code id"
#
# \description{
#       @get "title".
#	Use the \code{table.id} constructor argument to set the genetic code.
# }
#
# @synopsis
#
# \arguments{
#       \item{this}{An object.}
#       \item{value}{Not used.}
#       \item{...}{Not used.}
# }
#
# \value{
#	Throws an error.
# }
#
# @author
#
# \seealso{
#       @seeclass
# }
#
#*/###########################################################################
setMethodS3(
  "setTableId",
  class="CodonAlphabet",
  function(
    this,
		value,
    ...
  ){

		virtualAssignmentForbidden(this);	

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: translateCodon
##  
###########################################################################/**
#
# @RdocMethod translateCodon
# 
# @title "Translate a codon" 
# 
# \description{ 
#	@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
# 	\item{this}{A CodonAlphabet object.}
# 	\item{codon}{The codon to be translated.}
# 	\item{...}{Not used.} 
# } 
# 
# \value{ 
# 	A character vector containing an amino acid IUPAC code.
# } 
# 
# \examples{
#	# create a CodonAlphabet object
#	a<-CodonAlphabet()
#	# translate a codon
#	translateCodon(a,"AGG")
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "translateCodon",
  class="CodonAlphabet",
  function(
	this,
	codon,
	...
  ){

	if(!exists(x="PSIM_FAST")){
		if(missing(codon)){
			throw("No codon given!\n");
		}
		else if (!is.character(codon) | (length(codon) != 1)){
			throw("The codon argument must be a character vector of size 1!\n");
		}
		else if (length(intersect(names(this$.trans.table),codon)) != 1){
			throw("Codon not in translation table!\n");
		}
		else if (this$.trans.table[[codon]]$type == "STOP"){
			return("*");
		}
		else {
				return(this$.trans.table[[codon]]$aa);			
		}
	} else {

		return(this$.trans.table[[codon]]$aa);			
	}

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: isStopCodon
##  
###########################################################################/**
#
# @RdocMethod isStopCodon
# 
# @title "Check if a codon is a stop codon" 
# 
# \description{ 
#	@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
# 	\item{this}{A CodonAlphabet object.}
# 	\item{codon}{The codon to be checked.}
# 	\item{...}{Not used.} 
# } 
# 
# \value{ 
# 	TRUE or FALSE.
# } 
# 
# \examples{
#	# create a CodonAlphabet object
#	a<-CodonAlphabet()
#	# check some codons
#	isStopCodon(a,"ATG")
#	isStopCodon(a,"TGA")
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "isStopCodon",
  class="CodonAlphabet",
  function(
    this,
    codon,
    ...
  ){
	if(!exists(x="PSIM_FAST")){
		if(missing(codon)){
			throw("No codon given!\n");
		}
		else if (!is.character(codon) | (length(codon) != 1)){
			throw("The codon argument must be a character vector of size 1!\n");
		}
		else if (length(intersect(names(this$.trans.table),codon)) != 1){
			throw("Codon not in translation table!\n");
		}
	}	
		if (this$.trans.table[[codon]]$type == "STOP"){
			return(TRUE);
		}
		else {
				return(FALSE);			
		}

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: isStartCodon
##  
###########################################################################/**
#
# @RdocMethod isStartCodon
# 
# @title "Check if a codon is a start codon" 
# 
# \description{ 
#	@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
# 	\item{this}{A CodonAlphabet object.}
# 	\item{codon}{The codon to be checked.}
# 	\item{...}{Not used.} 
# } 
# 
# \value{ 
# 	TRUE or FALSE.
# } 
# 
# \examples{
#	# create a CodonAlphabet object
#	a<-CodonAlphabet()
#	# check some codons
#	isStartCodon(a,"ATG")
#	isStartCodon(a,"TGA")
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "isStartCodon",
  class="CodonAlphabet",
  function(
    this,
		codon,
    ...
  ){
	if(!exists(x="PSIM_FAST")){
		if(missing(codon)){
			throw("No codon given!\n");
		}
		else if (!is.character(codon) | (length(codon) != 1)){
			throw("The codon argument must be a character vector of size 1!\n");
		}
		else if (length(intersect(names(this$.trans.table),codon)) != 1){
			throw("Codon not in translation table!\n");
		}
	}
		
		if (this$.trans.table[[codon]]$type == "START"){
			return(TRUE);
		}
		else {
				return(FALSE);			
		}

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: areSynonymous
##  
###########################################################################/**
#
# @RdocMethod areSynonymous
# 
# @title "Check whether two codons are synonymous" 
# 
# \description{ 
#	@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
# 	\item{this}{A CodonAlphabet object.} 
#	\item{codons}{A vector containing two codons.}
# 	\item{...}{Not used.} 
# } 
# 
# \value{ 
# 	TRUE or FALSE.
# } 
# 
# \examples{
#	# create a CodonAlphabet object
#	a<-CodonAlphabet()
#	areSynonymous(a,c("TCC","TCT"))	
#	areSynonymous(a,c("TCC","CCT"))	
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "areSynonymous",
  class="CodonAlphabet",
  function(
	this,
	codons,
	...
  ){

	if(!exists(x="PSIM_FAST")){
		if(missing(codons)){
			throw("No codons given!\n");
		}
		else if (!is.character(codons) | (length(codons) != 2)){
			throw("The codons argument must be a character vector of size 2!\n");
		}
	}
		
		if (translateCodon(this,codons[1]) == translateCodon(this,codons[2])){
			return(TRUE);
		}
		else {
				return(FALSE);			
		}

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: .codonDiff
##  
setMethodS3(
  ".codonDiff",
  class="CodonAlphabet",
  function(
    this,
		codons,
    ...
  ){

	if(!exists(x="PSIM_FAST")){

		if(missing(codons)){
			throw("No codons given!\n");
		}
		else if (!is.character(codons) | (length(codons) != 2)){
			throw("The codons argument must be a character vector of size 2!\n");
		}
		else if (length(intersect(names(this$.trans.table),codons[1])) != 1){
			throw("Codon 1 is not in translation table!\n");
		}
		else if (length(intersect(names(this$.trans.table),codons[2])) != 1){
			throw("Codon 2 is not in translation table!\n");
		}
	}

			purines<-c("A","G");
			pyrimidines<-c("C","T");
			res<-character();

			codon1<-strsplit(codons[1],"",fixed=TRUE)[[1]];
			codon2<-strsplit(codons[2],"",fixed=TRUE)[[1]];

			for(i in c(1,2,3)){
					if(codon1[i] == codon2[i]) {
						res[i]<-0;
					}	
					else if ( length(intersect(purines,c(codon1[i],codon2[i]))) == 2 | length(intersect(pyrimidines,c(codon1[i],codon2[i]))) == 2 ){
						res[i]<-"TI";
					} else {
						res[i]<-"TV";
					}
			}
			return(res);	

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: summary
##  
###########################################################################/**
#
# @RdocMethod summary
#
# @title "Summarize the properties of an object"
#
# \description{
#       @get "title".
# }
#
# @synopsis
#
# \arguments{
#       \item{object}{An object}
#       \item{...}{Not used.}
# }
#
# \value{
#  Returns a PSRootSummary object.
# }
#
# \examples{
#
#       # create an object
#       a<-CodonAlphabet()
#       # get a summary
#       summary(a)
# }
#
# @author
#
# \seealso{
#       @seeclass
# }
#
#*/###########################################################################
setMethodS3(
  "summary",
  class="CodonAlphabet",
  function(
    object,
    ...
  ){

		NextMethod();

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: getTransTable
##  
###########################################################################/**
#
# @RdocMethod getTransTable
# 
# @title "Get the list storing the genetic code table" 
# 
# \description{ 
#	@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
# 	\item{this}{A CodonAlphabet object.} 
# 	\item{...}{Not used.} 
# } 
# 
# \value{ 
# 	A list.
# } 
# 
# \examples{
#	# create object
#	a<-CodonAlphabet()
#	# get genetic code table
#	getTransTable(a)
#	# get genetic code table via virtual field
#	a$transTable
# } 
# 
# @author 
# 
# \seealso{ 
# 	@seeclass 
# } 
# 
#*/###########################################################################
setMethodS3(
  "getTransTable",
  class="CodonAlphabet",
  function(
    this,
    ...
  ){

		this$.trans.table

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: setTransTable
##  
###########################################################################/**
#
# @RdocMethod setTransTable
#
# @title "Forbidden action: setting the genetic code table for a CodonAlphabet object"
#
# \description{
#       @get "title".
#	Use the \code{table.id} constructor argument to set the genetic code.
# }
#
# @synopsis
#
# \arguments{
#       \item{this}{An object.}
#       \item{value}{Not used.}
#       \item{...}{Not used.}
# }
#
# \value{
#	Throws an error.
# }
#
# @author
#
# \seealso{
#       @seeclass
# }
#
#*/###########################################################################
setMethodS3(
  "setTransTable",
  class="CodonAlphabet",
  function(
    this,
		value,
    ...
  ){

		virtualAssignmentForbidden(this);

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

##  
## Method: is.CodonAlphabet
##  
###########################################################################/**
#
# @RdocDefault is.CodonAlphabet
# 
# @title "Check if an object inherits from CodonAlphabet" 
# 
# \description{ 
#		@get "title".
# } 
# 
# @synopsis 
# 
# \arguments{ 
#		\item{this}{An object.}
#		\item{...}{Not used.}
#
# } 
# 
# \value{ 
#	TRUE of FALSE.
# } 
#
# \examples{
#	# create some objects
#	a<-CodonAlphabet()
#	p<-Process()
#	# check if they inherit from CodonAlphabet
#	is.CodonAlphabet(a)
#	is.CodonAlphabet(p)
# }
# 
# @author 
# 
#*/###########################################################################
setMethodS3(
  "is.CodonAlphabet",
  class="default",
  function(
    this,
    ...
  ){

    if(!is.PSRoot(this)) {return(FALSE)}
		else if(!is.null(this$.is.codon.alphabet)){return(TRUE)}
    else if ( inherits(this, "CodonAlphabet")) {
			this$.is.codon.alphabet<-TRUE;
      return(TRUE);
    } else {
      return(FALSE)
    }

  },
  private=FALSE,
  protected=FALSE,
  overwrite=FALSE,
  conflict="warning",
  validators=getOption("R.methodsS3:validators:setMethodS3")
);

