% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{TaxDict-class}
\alias{TaxDict-class}
\alias{TaxDict-method}
\alias{as.character,TaxDict-method}
\alias{show,TaxDict-method}
\alias{print,TaxDict-method}
\alias{str,TaxDict-method}
\alias{summary,TaxDict-method}
\title{Taxonomic record dictionary}
\usage{
\S4method{as.character}{TaxDict}(x)

\S4method{show}{TaxDict}(object)

\S4method{print}{TaxDict}(x)

\S4method{str}{TaxDict}(object, max.level = 2L, ...)

\S4method{summary}{TaxDict}(object)
}
\arguments{
\item{x}{\code{TaxDict} object}

\item{object}{\code{TaxDict} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}
}
\description{
Taxonomic dictionary contains a taxonomic
tree and NCBI taxonomy data for all taxonomic IDs.
}
\section{Slots}{

\describe{
\item{\code{txids}}{Taxonomic IDs of taxon records}

\item{\code{recs}}{Environment of records}

\item{\code{prnt}}{Parent taxonomic ID}

\item{\code{txtr}}{Taxonomic tree}
}}

\examples{
data('aotus')
txdct <- aotus@txdct
# this is a TaxDict object
# it contains taxonomic information, including records and tree
show(txdct)
# you can access its different data slots with @
txdct@txids  # taxonomic IDs
txdct@recs   # taxonomic records environment
txdct@txtr   # taxonomic tree
txdct@prnt   # MRCA
# access any record through the records environment
txdct@recs[[txdct@txids[[1]]]]
# for interacting with the taxonomic tree, see the treeman package
summary(txdct@txtr)
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxRec-class}},
  \code{\link{clusters2_run}}, \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
