% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-calc.R
\name{calc_wrdfrq}
\alias{calc_wrdfrq}
\title{Calculate word frequencies}
\usage{
calc_wrdfrq(phylota, cid, min_frq = 0.1, min_nchar = 1, type = c("dfln",
  "nm"), ignr_pttrn = "[^a-z0-9]")
}
\arguments{
\item{phylota}{Phylota object}

\item{cid}{Cluster ID(s)}

\item{min_frq}{Minimum frequency}

\item{min_nchar}{Minimum number of characters for a word}

\item{type}{Definitions (dfln) or features (nm)}

\item{ignr_pttrn}{Ignore pattern, REGEX for text to ignore.}
}
\value{
list
}
\description{
For all sequences in a cluster(s) calculate the frequency of
separate words in either the sequence definitions or the reported feature
name.
}
\details{
By default, anything that is not alphanumeric is  ignored. 'dfln'
and 'nm' match the slot names in a SeqRec, see list_seqrec_slots().
}
\examples{
data('dragonflies')
# work out what gene region the cluster is likely representing with word freqs.
random_cids <- sample(dragonflies@cids, 10)
# most frequent words in definition line
(calc_wrdfrq(phylota = dragonflies, cid = random_cids, type = 'dfln'))
# most frequent words in feature name
(calc_wrdfrq(phylota = dragonflies, cid = random_cids, type = 'nm'))
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{drop_by_rank}}, \code{\link{drop_clstrs}},
  \code{\link{drop_sqs}}, \code{\link{get_clstr_slot}},
  \code{\link{get_nsqs}}, \code{\link{get_ntaxa}},
  \code{\link{get_sq_slot}}, \code{\link{get_stage_times}},
  \code{\link{get_tx_slot}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
