% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistatisFast.R
\name{DistatisFast}
\alias{DistatisFast}
\title{Fast implementation the multivariate analysis method Distatis}
\usage{
DistatisFast(matrices, factorskept = "auto", parallel = TRUE)
}
\arguments{
\item{matrices}{A list of K distance matrices, all of the same dimension (IxI).}

\item{factorskept}{Number of factors to keep for the computation of the factor. When "auto" (the default), a brokenstick model is used for the choice of the number of components to keep.}

\item{parallel}{Should the matrix products computations be parallelized? Default to TRUE. 
scores of the observations.}
}
\value{
Returns a list containing:
\itemize{
 \item \code{F}: projected coordinates of species in the compromise
 \item \code{PartialF}: list of projected coordinates of species for each gene.
	\item \code{alpha}: array of length K of the weight associated to each matrix.
 \item \code{lambda}: array of length K of the normalization factors used for each matrix. lambda=1 always.
	\item \code{RVmat}: a KxK matrix with RV correlation coefficient computed between all
 pairs of matrices.
	\item \code{compromise}: an IxI matrix representing the best compromise between all matrices. This matrix is the weighted average of all K matrices, using 'alpha' as
a weighting array.
	\item \code{quality}: the quality of the compromise. This value is between 0 and 1 
	\item \code{matrices.dblcent}: matrices after double centering
describes how much of the variance of the K matrices is captured by the compromise.   
}
}
\description{
New implementation of the DISTATIS method for K matrices of dimension IxI.
This version of Distatis is faster than the original one because only the minimum required number
of eigenvalues and eigenvectors is calculated. The difference in speed 
is particularly visible when the number of matrices is large.
}
\examples{
# Get a list of matrices 
# from the carnivora dataset
data(carnivora) 
matrices <- phylter(carnivora, InitialOnly = TRUE, parallel = FALSE)$matrices

# Perform a Distatis analysis on these matrices: 
distatis <- DistatisFast(matrices, parallel = FALSE)

#distatis is a list with multiple elements: 
distatis$alpha #weigh of each matrix (how much it correlates with others)
distatis$RVmat #RV matrix: correlation of each matrix with each other
distatis$compromise # distance matrix with "average" pairwise distance between species in matrices
# etc.

}
\references{
Abdi, H., Valentin, D., O'Toole, A.J., & Edelman, B. (2005).
DISTATIS: The analysis of multiple distance matrices.
Proceedings of the IEEE Computer Society: International
Conference on Computer Vision and Pattern Recognition_.  (San
Diego, CA, USA). pp. 42-47.
}
