% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-utils.R
\name{simulate.communityPGLMM}
\alias{simulate.communityPGLMM}
\title{Simulate from a communityPGLMM object}
\usage{
\method{simulate}{communityPGLMM}(object, nsim = 1, seed = NULL, re.form = NULL, ...)
}
\arguments{
\item{object}{A fitted model object with class 'communityPGLMM'.}

\item{nsim}{positive integer scalar - the number of responses to simulate.}

\item{seed}{an optional seed to be used in \code{\link{set.seed}}
    immediately before the simulation so as to generate a reproducible sample.}

\item{re.form}{(formula, \code{NULL}, or \code{NA}) specify which random effects to condition on when predicting.
If \code{NULL}, include all random effects and the conditional modes of those random effects will be included in the deterministic part of the simulation (i.e Xb + Zu);
if \code{NA} or \code{~0}, include no random effects and new values will be chosen for each group based on the estimated random-effects variances (i.e. Xb + Zu * u_random).}

\item{...}{optional additional arguments: none are used at present.}
}
\description{
Note that this function currently only works for model fit with \code{bayes = TRUE}
}
