% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bmi.R
\name{blood_vol_Nadler}
\alias{blood_vol_Nadler}
\alias{blood_vol_lemmens_indexed}
\alias{blood_vol_lemmens_non_obese}
\alias{blood_vol_lemmens_sedentary}
\title{Estimate Blood Volume}
\usage{
blood_vol_Nadler(heightm, weightkg, male, warn = FALSE)

blood_vol_lemmens_sedentary(heightm, weightkg)

blood_vol_lemmens_indexed(heightm, weightkg)

blood_vol_lemmens_non_obese(weightkg, age, male)
}
\arguments{
\item{heightm}{single numeric, height in meters}

\item{weightkg}{numeric vector of weight(s) in kg}

\item{male}{logical}

\item{warn}{single logical, if TRUE, will produce warnings for very
unrealistic physical measurements, and other minor problems}

\item{age}{years}
}
\value{
numeric vector
}
\description{
estimate blood volume according to the classic 1960s paper by
  Nadler. Surgery. 1962 Feb;51(2):224-32. Prediction of blood volume in
  normal human adults. Nadler SB, Hidalgo JH, Bloch T.

This effectively reverses engineers an ideal weight from BMI of
  22, then use the sqaure root of its ratio to actual body weight to adjust
  the 70ml/kg of an ideal weight person. Age-dependent regression equations
  for indexed blood volume (InBV) at ideal body weight. (No adjustment made
  in obesity by Lemmens.) InBV = 90-0.4 X age (males) InBV = 85-0.4 X age
  (females). Sounds like he is saying either they are slim and old or younger
  and obese. he doesn't attempt to integrate the formulae.

  TODO: include age as cut-off butween the use of differing formulae.

applies to slim adults, but note that the age-related decline is
  not seen if high degree of physical activity is maintained. TODO: check BMI
  not elevated
}
\details{
Davy KP, Seals DR. Total blood volume in healthy young and older
  men. J Appl Physiol 1994; 76: 2059-62.

  Parker-Jones P, Davy KP, DeSouza CA et al. Absence of agerelated decline in
  total blood volume in physically active females. Am J Physiol 1997; 272:
  H2534-40.
}
\examples{
blood_vol_Nadler(1.8, 80, male = TRUE)
blood_vol_Nadler(1.8, 160, male = TRUE)
blood_vol_Nadler(1.8, 80, male = FALSE)
blood_vol_lemmens_sedentary(1.8, 80)
blood_vol_lemmens_sedentary(1.8, 160)
blood_vol_lemmens_indexed(1.8, 80)
blood_vol_lemmens_indexed(1.8, 160)
blood_vol_lemmens_non_obese(80, age = 25, male = TRUE)
  blood_vol_lemmens_non_obese(80, age = 75, male = TRUE)
}

