% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Romano_Patterson_Candes_2018.R
\name{CQRF}
\alias{CQRF}
\title{implements RF prediction interval using split conformal prediction as outlined in Romano, Patterson, Candes 2018. Helper function.}
\usage{
CQRF(
  formula = NULL,
  train_data = NULL,
  pred_data = NULL,
  num_trees = NULL,
  min_node_size = NULL,
  m_try = NULL,
  keep_inbag = TRUE,
  intervals = TRUE,
  alpha = NULL,
  forest_type = "RF",
  num_threads = NULL,
  interval_type = NULL
)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{train_data}{Training data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Matches ranger() requirements.}

\item{pred_data}{Test data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL). Utilizes ranger::predict() to get prediction intervals for test data.}

\item{num_trees}{Number of trees.}

\item{min_node_size}{Minimum number of observations before split at a node.}

\item{m_try}{Number of variables to randomly select from at each split.}

\item{keep_inbag}{Saves matrix of observations and which tree(s) they occur in. Required to be true to generate variance estimates for Ghosal, Hooker 2018 method. *Should not be an option...}

\item{intervals}{Generate prediction intervals or not.}

\item{alpha}{Significance level for prediction intervals.}

\item{forest_type}{Determines what type of forest: regression forest vs. quantile regression forest. *Should not be an option...}

\item{num_threads}{The number of threads to use in parallel. Default is the current number of cores.}

\item{interval_type}{Type of prediction interval to generate.
Options are \code{method = c("two-sided", "lower", "upper")}. Default is  \code{method = "two-sided"}.}
}
\description{
This function implements split conformal prediction intervals for RFs. Currently used in rfint().
}
\keyword{internal}
