% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{alleleClusterNames}
\alias{alleleClusterNames}
\title{Allele similarity cluster naming scheme}
\usage{
alleleClusterNames(cluster, allele.cluster.table, germ.dist, chain, segment)
}
\arguments{
\item{cluster}{A vector with the cluster identifier - the family and allele cluster number.}

\item{allele.cluster.table}{A data.frame with the list of all germline sequences and their clusters.}

\item{germ.dist}{A matrix with the germline distance between the germline set sequences.}

\item{chain}{A character with the chain identifier: IGH/IGL/IGK/TRB/TRA... (Currently only IGH is supported)}

\item{segment}{A character with the segment identifier: IGHV/IGHD/IGHJ.... (Currently only IGHV is supported)}
}
\value{
A data.frame with the clusters renamed alleles based on the ASC scheme.
}
\description{
For a given cluster the function collapse similar sequences and renames the sequences based on the ASC name scheme
}
