% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{generateReferenceSet}
\alias{generateReferenceSet}
\title{Generate allele similarity reference set}
\usage{
generateReferenceSet(germline_distance, germline_set, alleleClusterTable)
}
\arguments{
\item{germline_distance}{A germline set distance matrix created by \link{ighvDistance}.}

\item{germline_set}{A character list of the IMGT aligned IGHV allele sequences. See details for curating options.}

\item{alleleClusterTable}{A data.frame of the alleles and their clusters created by \link{ighvClust}.}
}
\value{
A \code{list} with the re-named germline set, and a table of the allele clusters and thresholds.
}
\description{
Generates the allele clusters reference set based on the clustering from \link{ighvClust}. The function collapse
similar alleles and assign them into their respective allele clusters and family clusters. See details for naming scheme
}
\details{
Each allele is named by this scheme:
IGHVF1-G1*01 - IGH = chain, V = region, F1 = family cluster numbering,
G1 - allele cluster numbering, and 01 = allele numbering (given by clustering order, no connection to the expression)
}
