% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR.R
\name{L}
\alias{L}
\alias{PP}
\alias{R}
\title{Specify the left hand and right hand side of an expression used in pims}
\usage{
L(x)

R(x)

PP(x)
}
\arguments{
\item{x}{any vector specified in a formula}
}
\value{
a vector with the pseudo-observations for x, based on the 
poset used to create the function. If used in a wrong context (i.e.
not in a call to \code{pim}), it returns \code{x} unchanged and throws
a warning.
}
\description{
These functions allow you to specify the left hand side and 
right hand side of a term in a pim model. The user should
only use this functions within a formula using the \code{\link{pim}}
function. Use in a different context will return an error.
}
\details{
These specific functions are actually not used by the 
function \code{\link{pim}}. \code{pim} calls the internal function
\code{\link{.make.posfun}} to create the actual functions \code{L}
and \code{R} to work with the specified posets of the model of 
interest.

The actual functions used by \code{pim} are saved in a specific environment, a \code{\link{pim.environment}}, which resides in the \code{\link{pim-class}} object returned by \code{pim}. This way of working
is chosen in order to avoid unnecessary copying of data.

The function \code{PP} serves simply as short for \code{R(x) - L(x)}. If used outside the context of a pim model, it will generate
multiple warnings (see section warning).
}
\section{warning}{


These functions serve only as placeholder. During the fitting process
of a pim, they get updated to include the posets (the indices that
determine which observations are compared)
Note that this makes the functions behave fundamentally
different from what you would expect R. The result of these
functions depends on the context in which they are called.
}
\examples{
\dontrun{
pim(income~(L(foodexp) - R(foodexp)), data=Engeldata)
L(1:10) # Gives a warning
}
}

