% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\docType{methods}
\name{formula}
\alias{formula}
\alias{formula,pim-method}
\alias{formula,pim.formula-method}
\title{Extract the formula from a pim or pim.formula object}
\usage{
formula(x, ...)

\S4method{formula}{pim}(x, orig = FALSE, ...)

\S4method{formula}{pim.formula}(x, ...)
}
\arguments{
\item{x}{a \code{pim} or \code{pim.formula} object}

\item{...}{arguments passed to other methods}

\item{orig}{a locigal value indicating whether the original formula
(\code{TRUE}) or the \code{pim.formula} object (\code{FALSE}) should
be returned. Defaults to \code{FALSE}}
}
\value{
a \code{\link{pim.formula}} if \code{x} is a \code{pim}
object and \code{orig = TRUE}. Otherwise a \code{\link[stats]{formula}} object.
}
\description{
This function allows you to extract a formula from a \code{\link{pim}}
or a \code{\link{pim.formula}} object. In the latter case, you extract
the original formula.
}
\details{
This function is based on \code{\link[stats]{formula}} from the stats 
package. It creates a generic and can hence be used more or less in the 
same way. Yet, as the pim package is dependent on the correct
binding between the formula objects and different environments, it is
advised not to change the environments tied to the formulas and to
use this function only to extract the desired information.
}
\examples{
data("DysData")
themodel <- pim(SPC_D2 ~ Chemo, data = DysData)

thepimform <- formula(themodel)
formula(thepimform)
formula(themodel, orig = TRUE)

}
\seealso{
\code{\link{pim.formula-class}} and \code{\link{pim-class}} for 
more information on the classes.
}

