% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_evidences.R
\name{est_evidences}
\alias{est_evidences}
\title{Estimate the evidences}
\usage{
est_evidences(fasta_filename, experiments, evidence_filename, verbose = FALSE)
}
\arguments{
\item{fasta_filename}{name of a FASTA file.
Use \link{get_alignment_id} to get the ID of the alignment}

\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}

\item{evidence_filename}{filename to store the estimated
evidences (aka marginal likelihoods),
as can be created by \link{get_temp_evidence_filename}.
Must be \link{NA} if there is evidence
estimation (as determined by \link{will_measure_evidence}).}

\item{verbose}{if TRUE, show more output}
}
\value{
a data frame with evidences. Returns NULL if there
  are no experiments that have their evidence measured.
}
\description{
Estimate the evidences
}
\examples{
if (rappdirs::app_dir()$os != "win" &&
  beautier::is_on_ci() &&
  is_beast2_installed() &&
  is_beast2_ns_pkg_installed()
) {
  fasta_filename <- system.file(
    "extdata", "alignment.fas", package = "pirouette"
  )

  # Create a single one candidate experiment
  experiments <- list(create_test_cand_experiment())

  # Collect the evidences
  est_evidences(
    fasta_filename = fasta_filename,
    experiments = experiments
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
