% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sim_tral_fun.R
\name{check_sim_tral_fun}
\alias{check_sim_tral_fun}
\title{Check if the function to create a true alignment with (from the
true phylogeny) is valid.}
\usage{
check_sim_tral_fun(sim_tral_fun)
}
\arguments{
\item{sim_tral_fun}{function to simulate a
true alignment with.
This function must have two arguments,
called \code{true_phylogeny} (which will hold the true phylogeny)
and \code{root_sequence} (which holds the DNA root sequence).
The return type must be \link[ape]{DNAbin}.

Use \link{check_sim_tral_fun} to verify if the function
has the right signature and output.

Some standard functions:\cr
\itemize{
  \item Use \link{get_sim_tral_with_std_nsm_fun}
  to get a function (\link{sim_tral_with_std_nsm})
  the use a standard site model.
  \item Use
  \link{get_sim_tral_with_lns_nsm_fun}
  to get a function
  (\link{sim_tral_with_lns_nsm})
  the use a linked node substitution site model.
  \item Use
  \link{get_sim_tral_with_uns_nsm_fun}
  to get a function
  (\link{sim_tral_with_uns_nsm})
  the use an unlinked node substitution site model.
}}
}
\value{
nothing
}
\description{
Will \link{stop} if not
}
\seealso{
Use \link{check_sim_twal_fun} to check a function to
generate a twin alignment
}
\author{
Richèl J.C. Bilderbeek
}
