% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sim_twal_fun.R
\name{check_sim_twal_fun}
\alias{check_sim_twal_fun}
\title{Check if the function to create a twin alignment with (from a
true phylogeny and a true alignment) is valid.}
\usage{
check_sim_twal_fun(sim_twal_fun)
}
\arguments{
\item{sim_twal_fun}{function to simulate a
twin alignment with.
This function must have two arguments called \code{twin_phylogeny} (which
will hold the twin phylogeny) and \code{true_alignment} (which will
hold the alignment simulated from the true phylogeny). The
return type must be \link[ape]{DNAbin}.

Use \link{check_sim_twal_fun} to verify if the function
has the right signature and output.

Some standard functions:\cr
\itemize{
  \item Use \link{get_copy_tral_fun}
    to get a function
    (\link{copy_true_alignment})
    that copies a true to alignment to create a twin alignment
  \item Use \link{get_sim_twal_with_std_nsm_fun}
    to get a function
    (\link{sim_twal_with_std_nsm})
    that simulates a twin alignment using a standard site model
  \item Use \link{get_sim_twal_same_n_muts_fun}
    to get a function
    (\link{sim_twal_with_same_n_mutation})
    that simulates -using a standard model- a twin alignment with as much
    mutations compared to the root sequence as the true alignment has
  \item Use \link{sim_twal_with_lns_nsm}
    that simulates a twin alignment using a linked node substitution
    model
  \item Use \link{sim_twal_with_uns_nsm}
    that simulates a twin alignment using an unlinked node substitution
    model
}}
}
\value{
nothing
}
\description{
Will \link{stop} if not
}
\seealso{
Use \link{check_sim_tral_fun} to check a function to
generate a true alignment.
Use \link{check_sim_twin_tree_fun} to check a function to
generate a twin phylogeny.
}
\author{
Richèl J.C. Bilderbeek
}
