% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_filter.R
\name{build_filter}
\alias{build_filter}
\title{Build filter from tribble}
\usage{
build_filter(filters, global_operator = "and")
}
\arguments{
\item{filters}{tribble with columns

\itemize{
  \item column
  \item operator
  \item value
}

Possible values for operator:
\itemize{
  \item (not_)contains
  \item (not_)icontains
  \item start_with
  \item ends_with
  \item (not_)matches
  \item eq
  \item neq
  \item (not_)empty
}}

\item{global_operator}{"and" or "or"}
}
\value{
filter json encoded to feed to \code{\link{build_query}}
}
\description{
Build filter from tribble
}
\examples{
filters <- tibble::tribble(
 ~column, ~operator, ~value,
 "event_url", "matches", "Zamperoni",
 "event_url", "matches", "-1[34]"
)
# With optional transformation
filters <- tibble::tribble(
 ~column, ~operator, ~value, ~transformation,
 "event_url", "starts_with", "/medien", "to_path",
 "event_url", "matches", "-1[34]", NULL
)
 filters <- build_filter(filters, "and")

# If values of two or more different types are used use lists

filters <- tibble::tribble(
  ~column, ~operator, ~value,
  "device_type", "eq", list(0),
  "location_country_name", "eq", list("DE")
)

}
