% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/place_rule.R
\name{place_rule}
\alias{place_rule}
\title{Places a line on the rgb plot}
\usage{
place_rule(x_axis, y_axis, line_type = "f")
}
\arguments{
\item{x_axis}{a character string indicating the colour variable that
corresponds to the x axis, one of \code{"r"}, \code{"g"} or \code{"b"}.}

\item{y_axis}{a character string indicating the colour variable that
corresponds to the y axis, one of \code{"r"}, \code{"g"} or \code{"b"}.}

\item{line_type}{a character string indicating that the line is vertical
\code{"v"}, horizontal \code{"h"} or free (\code{"f"}, the default).}
}
\value{
A list of class \code{rule_points} containing the following elements:
\itemize{
\item \code{x_axis}: a character string containing the colour variable
  selected as \code{x} axis.
\item \code{y_axis}: a character string containing the colour variable
  selected as \code{y} axis.
\item \code{first_point}: coordinates of the start point of the line.
\item \code{second_point}: coordinates of the end point of the line.
}
}
\description{
A wrapper function for \code{graphics::locator} that makes the creation
of rules easier.
}
\details{
This function calls \code{graphics::locator} allowing to select two
  points, plots the line joining these points and returns a list
  containing their coordinates. The coordinates are rearranged to
  pass them to \code{define_rule()}.

  True horizontal and vertical lines are difficult to create by hand. In
  these cases, specifying \code{"vertical"} or \code{"horizontal"} (partial
  match allowed, i e "h") will copy the appropriate coordinate value from the
  first point to the second. Note that this is done after \code{locator()}
  returns, so the plot will show the line joining the original points, not
  the corrected ones. Use \code{plot_rule()} to see corrected line.
}
\examples{
\dontrun{
plot_rgb_plane("r", "g")
line01 <- place_rule("r", "g")          # A "free" line
line02 <- place_rule("r", "g", "h")     # A horizontal line
}

}
\seealso{
\code{\link[graphics]{locator}}, \code{\link{define_rule}},
  \code{\link{plot_rule}}, \code{\link{plot_rgb_plane}}
}
