% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_fn.R
\name{sprinkle_fn}
\alias{sprinkle_fn}
\alias{sprinkle_fn.default}
\alias{sprinkle_fn.dust_list}
\title{Apply a function to a selection of cells}
\usage{
sprinkle_fn(x, rows = NULL, cols = NULL, fn = NULL,
  part = c("body", "head", "foot", "interfoot", "table"),
  fixed = FALSE, recycle = c("none", "rows", "cols"), ...)

\method{sprinkle_fn}{default}(x, rows = NULL, cols = NULL, fn = NULL,
  part = c("body", "head", "foot", "interfoot", "table"),
  fixed = FALSE, recycle = c("none", "rows", "cols", "columns"), ...)

\method{sprinkle_fn}{dust_list}(x, rows = NULL, cols = NULL,
  fn = NULL, part = c("body", "head", "foot", "interfoot", "table"),
  fixed = FALSE, recycle = c("none", "rows", "cols", "columns"), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{fn}{An object of class \code{call}. The function should act on 
an object \code{value} (which is an internal column in the \code{dust}
object). It is recommend to wrap the function call in \code{quote}.
For example, \code{quote(pvalString(value))} or 
\code{quote(format(value, nsmall = 3))}.}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
The pre-defined sprinkles do not always provide the 
  desired impact on the tables. Applying a function allows for 
  highly customized output without having to pre-process that data 
  frame.
}
\details{
\code{dust} objects transform tabular objects so that each cell
  in the table comprises one row in the data frame of cell attributes.  
  The function to be applied needs to act on the \code{value} column of
  that data frame.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements \code{fn} column
   in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{fn} is not a \code{call} object.
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}
}

\author{
Benjamin Nutter
}
