% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{buildPackageGraph}
\alias{buildPackageGraph}
\title{Build a graph of an R package or directory}
\usage{
buildPackageGraph(x, unique.edges = TRUE, only.connected = FALSE)
}
\arguments{
\item{x}{A character string specifying the path to an R package or directory}

\item{unique.edges}{Logical indicating whether there should be only a single 
edge between nodes.
DEFAULT: TRUE}

\item{only.connected}{Logical indicating whether unconnected nodes should be
removed from the graph.
DEFAULT: FALSE}
}
\value{
A named list of length 2 containing a character vector of nodes and a
data.frame of edges.
}
\description{
Generates the Nodes and Edges of a set of functions in an R package or directory
}
\examples{
system.file("extdata", package = "pkgGraphR") |> 
    buildPackageGraph()

}
