% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async}
\alias{async}
\title{Create an async function}
\usage{
async(fun)
}
\arguments{
\item{fun}{Original function.}
}
\value{
Async version of the original function.
}
\description{
Create an async function, that returns a deferred value, from a
regular function. If \code{fun} is already an async function, then it does
nothing, just returns it.
}
\details{
The result function will have the same arguments, with the same default
values, and the same environment as the original input function.
}
\examples{
f <- function(x) 42
af <- async(f)
is_async(f)
is_async(af)
f()
synchronise(dx <- af())
dx
}
