% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_filter}
\alias{async_filter}
\alias{async_reject}
\title{Keep or drop elements using an asyncronous predicate function}
\usage{
async_filter(.x, .p, ...)

async_reject(.x, .p, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{An asynchronous predicate function.}

\item{...}{Additional arguments to the predicate function.}
}
\value{
A deferred value for the result.
}
\description{
\code{async_filter} keep the elements for which \code{.p} is true. (Tested
via \code{isTRUE()}. \code{async_reject} is the opposite, it drops them.
}
\examples{
\donttest{
## Filter out non-working URLs
afun <- async(function(urls) {
  test_url <- async_sequence(
     http_head, function(x) identical(x$status_code, 200L))
  async_filter(urls, test_url)
})
urls <- c("https://eu.httpbin.org/get",
          "https://eu.httpbin.org/status/404")
synchronise(afun(urls))
}
}
\seealso{
Other async iterators: \code{\link{async_detect}},
  \code{\link{async_every}}, \code{\link{async_map}}
}
\concept{async iterators}
