% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{delay}
\alias{delay}
\title{Delay async computation for the specified time}
\usage{
delay(delay)
}
\arguments{
\item{delay}{Time interval in seconds, the amount of time to delay
to delay the execution. It can be a fraction of a second.}
}
\value{
A deferred object.
}
\description{
Since R is single-threaded, the deferred value might be resolved (much)
later than the specified time period.
}
\examples{
\donttest{
## Two HEAD requests with 1/2 sec delay between them
resp <- list()
afun <- async(function() {
  http_head("https://eu.httpbin.org?q=2")$
    then(function(value) resp[[1]] <<- value$status_code)$
    then(function(...) delay(1/2))$
    then(function(...) http_head("https://eu.httpbin.org?q=2"))$
    then(function(value) resp[[2]] <<- value$status_code)
})
synchronise(afun())
resp
}
}
