% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/news.R
\name{news}
\alias{news}
\title{Read package news}
\usage{
news(package, installed_only = FALSE, allow_changelog = TRUE, width = NULL)
}
\arguments{
\item{package}{Character string giving the name of an R package.}

\item{installed_only}{Only check installed packages.}

\item{allow_changelog}{Whether to try and find a ChangeLog file if the
NEWS can't be found.}

\item{width}{An optional positive integer - see \code{\link[base:strwrap]{base::strwrap()}}.}
}
\value{
A character vector containing the contents of the package's NEWS file
(or possibly the ChangeLog file, if \code{allow_changelog = TRUE}). An error is
thrown if no news could be found.
}
\description{
Retrieve the NEWS file of a package as a character vector.
}
\examples{
  \dontrun{news("pkgnews")}

}
