% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hit_map.R
\name{hit_map}
\alias{hit_map}
\title{Platemap to identify 'hits' in a screen}
\usage{
hit_map(data, well, plate = 96, threshold = 2, palette = "Spectral")
}
\arguments{
\item{data}{Vector of numerical values to score}

\item{well}{Vector of well identifiers e.g "A01"}

\item{plate}{Number of wells in complete plate (96, 384 or 1536)}

\item{threshold}{Numerical value of standard deviations from the mean
for a well to be classified as a 'hit'. Default it +/- 2 SD}

\item{palette}{RColorBrewer palette}
}
\value{
ggplot plot
}
\description{
Produces a plot in the form of a micro-titre layout,
with colours indicating wells above or below a nominated threshold.
}
\examples{
df <- data.frame(vals = rnorm(1:384),
  well = num_to_well(1:384, plate = 384))

hit_map(data = df$vals,
       well = df$well,
       plate = 384,
       threshold = 3)
}
