library(deSolve)

icfModel <- function(t,state,parameters){
  with(
    as.list(c(state,parameters)), {
      # Concentrations
      CMUSCLE<-AMUSCLE/VOLMUSCLE
      CVMUSCLE<-CMUSCLE/PMUSCLE
      CSKIN<-ASKIN/VOLSKIN
      CVSKIN <- CSKIN / PSKIN 
      CBONE<-ABONE/VOLBONE
      CVBONE<-CBONE/PBONE
      CMARROW<-AMARROW/VOLMARROW
      CVMARROW<-CMARROW/PMARROW
      CFAT<-AFAT/VOLFAT
      CVFAT <-  CFAT / PFAT   
      CSTOM<- 1.6 #ASTOM/VOLINTEST?
      CVSTOM<- 2 #CSTOM/PSTOM?
      CLIVER<-ALIVER/VOLLIVER
      CVLIVER <-  CLIVER / PLIVER 
      CMET<-AMET/VOLLIVER
      CHEART<-AHEART/VOLHEART
      CVHEART <- CHEART / PHEART 
      CLUNG<-ALUNG/VOLLUNGS
      CVLUNG <- CLUNG / PLUNG  
      CINH<-1.6#*CEXP/(MW*RESPPROT)
      
      CKIDNEY<-AKIDNEY/VOLKIDNEY
      CVKIDNEY<-CKIDNEY/PKIDNEY
      CEXC<-AEXC/URINVOL
      CBRAIN<-ABRAIN/VOLBRAIN
      CVBRAIN<-CBRAIN/PBRAIN
      CVEN<- 1 #AVEN?/VOLBLUNGVEN?
      CART<- 1.5 #?AART/VOLBLUNGART
      CALV<- 1.6 #CART/RCBA

      #Oral Exposure
      RTOTDOSE <- 1
      avlbl_dose<- dbr * oralDose
      RODOSE <- -avlbl_dose
      # Amounts
      # muscle
      RAMUSCLE<-CART*QMUSCLE - CVMUSCLE*QMUSCLE
      #skin
      RASKIN<-CART*QSKIN - CVSKIN*QSKIN
      # bone
      RABONE<-CART*QBONE - CVBONE*QBONE
      #Marrow
      RAMARROW<-CART*QMARROW - CVMARROW*QMARROW
      # fat
      RAFAT<-CART*QFAT - CFAT*QFAT
      # Gastric
      RASTOM<-avlbl_dose + CART*QLIVVEN - CVSTOM*QLIVVEN
      # Liver Metab
      RAMET<- 1 #CVLIVER*VMAX?/(CVLIVER + KM)
      #LIVER
      RALIVER<-CART*QLIVART - CVLIVER*QLIVART - CVLIVER*QLIVVEN + CVSTOM*QLIVVEN - RAMET
      # Heart
      RAHEART<-CART*QHEART - CVHEART*QHEART
      # Lung
      RALUNG<-CART*QLUNG - CVLUNG*QLUNG
      # Exhaled from Lung
      RAEXH<- 1 #ALVVENT?*CALV
      # Inhaled into Lung
      RAINH<- 1 #?ALVVENT*CINH
      # Kidney Exceretion
      RAEXC<- 1 #CVKIDNEY*FRWSOL?*GLOMFILTR*QKIDNEY*REMOVKDN
      # Kidney
      RAKIDNEY<- 1 #CART*QKIDNEY - CVKIDNEY*QKIDNEY - RAEXC
      
      # Urine Generation
      RURINVOL<-0.0416666666666667*BODYWT #*URINFLOW?
      #Brain
      RABRAIN<-CART*QBRAIN - CVBRAIN*QBRAIN
      # Arterial Blood
      RAART<- 1 #ALVVENT?*CALV + ALVVENT*CINH - CART*CARDOUTP + CVEN*CARDOUTP
      # venous Blood
      RAVEN<-CVFAT*QFAT + CVBONE*QBONE + CVBRAIN*QBRAIN + CVHEART*QHEART + CVKIDNEY*QKIDNEY + CVLIVER*QLIVART + CVLIVER*QLIVVEN + CVLUNG*QLUNG + CVMARROW*QMARROW + CVMUSCLE*QMUSCLE + CVSKIN*QSKIN - CVEN*CARDOUTP
      
      # Area Under Curves
      RAUCMUSCLE <- CMUSCLE
      RAUCBRAIN <- CBRAIN
      RAUCLIVER <- CLIVER
      RAUCBONE <- CBONE
      RAUCLUNG <- CLUNG
      RAUCSKIN <- CSKIN
      RAUCMARROW <- CMARROW
      RAUCVEN  <- CVEN
      RAUCFAT <- CFAT
      RAUCKIDNEY <- CKIDNEY
      RAUCSTOM <- 1 # CSTOM?
      RAUCART <- CART
      RAUCHEART <- CHEART
      
      # MAss Balance
      TOTBOD<-AFAT + AART + ABONE + ABRAIN + AHEART + AKIDNEY + ALIVER + ALUNG + AMARROW + AMUSCLE + DOSE + ASKIN + ASTOM + AVEN
      TOTCLEAR<-AEXC + AEXH + AMET
      TMASS<- TOTDOSE-TOTBOD - TOTCLEAR
      
      list(c(RAMUSCLE,RAEXH,RABRAIN,RAEXC,RALIVER,RABONE,RALUNG,RASKIN,RAMARROW,RAINH,RAVEN,RURINVOL,RAFAT,RAKIDNEY,RASTOM,RAMET,RTOTDOSE,RODOSE,RAART,RAHEART,
             RAUCMUSCLE,RAUCBRAIN,RAUCLIVER,RAUCBONE,RAUCLUNG,RAUCSKIN,RAUCMARROW,RAUCVEN,RAUCFAT,RAUCKIDNEY,RAUCSTOM,RAUCART,RAUCHEART),
           "cmusc"=CMUSCLE,"cbrn"=CBRAIN,"cliv"=CLIVER,"cbne"=CBONE,"clng"=CLUNG,"cskn"=CSKIN,"cmarr"=CMARROW,"cven"=CVEN,"cfat"=CFAT,"ckdn"=CKIDNEY,
           "cstm"=CSTOM,"cart"=CART,"chrt"=CHEART,"bal"=TMASS
           )
    })
}