% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_crop}
\alias{mosaic_crop}
\title{Crop or Mask a Mosaic Raster}
\usage{
mosaic_crop(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  shapefile = NULL,
  in_memory = FALSE,
  mosaic2 = NULL,
  buffer = 0,
  show = c("rgb", "index"),
  index = "R",
  max_pixels = 5e+05,
  downsample = NULL,
  type = c("crop", "mask"),
  ...
)
}
\arguments{
\item{mosaic}{A \code{SpatRaster} object to be cropped.}

\item{r, g, b, re, nir}{Integer indices representing the red, green, blue, red-edge, and near-infrared
bands of the input mosaic. Default assumes BGR format (b = 1, g = 2, r = 3).}

\item{shapefile}{An optional \code{SpatVector} (or \code{sf} object) to use as cropping/masking geometry.
Can be created interactively with \code{\link[=shapefile_input]{shapefile_input()}}.}

\item{in_memory}{Logical. If \code{TRUE}, raster processing will occur entirely in memory using \code{terra}.
If \code{FALSE} (default), disk-based processing with GDAL will be used when appropriate.}

\item{mosaic2}{A second \code{SpatRaster} whose extent will be used to crop \code{mosaic}.}

\item{buffer}{A numeric value indicating a buffer (in CRS units) to apply around the shapefile geometry.}

\item{show}{A character value indicating what to display in the interactive viewer. Either \code{"rgb"} or \code{"index"}.}

\item{index}{The index to show if \code{show = "index"}. Default is \code{"R"}.}

\item{max_pixels}{Maximum number of pixels to render in the interactive viewer.}

\item{downsample}{Optional downsampling factor for display purposes.}

\item{type}{Either \code{"crop"} (default) or \code{"mask"}:
\itemize{
\item \code{"crop"} crops the mosaic to the bounding box of the shapefile.
\item \code{"mask"} sets pixels outside the shapefile geometry to \code{NA} (recommended when using exact shapes).
}}

\item{...}{Additional arguments passed to \code{\link[=mosaic_view]{mosaic_view()}}.}
}
\value{
A cropped or masked \code{SpatRaster} object.
}
\description{
This function allows cropping of a raster mosaic interactively or programmatically:
\itemize{
\item \strong{Interactive Mode}: If neither \code{shapefile} nor \code{mosaic2} is provided, an interactive map
is shown via \code{\link[=mosaic_view]{mosaic_view()}}, allowing users to draw a rectangle to define the cropping area.
\item \strong{Shapefile Mode}: If a \code{SpatVector} is provided in \code{shapefile}, cropping or masking is performed
based on its extent or exact shape, optionally with a buffer.
\item \strong{Raster Mode}: If \code{mosaic2} is provided, \code{mosaic} will be cropped to match the extent of \code{mosaic2}.
}

For disk-based mosaics, cropping with shapefiles uses GDAL (\code{sf::gdal_utils()}) to improve efficiency.
}
\details{
Crop or mask a \code{SpatRaster} object (\code{mosaic}) based on user input from an
interactive map or by using a provided shapefile or another raster.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
  library(pliman)
  # Load a sample raster
  mosaic <- mosaic_input(system.file("ex/elev.tif", package = "terra"))

  # Interactive cropping with drawn rectangle
  cropped <- mosaic_crop(mosaic)

  # View result
  mosaic_view(cropped)
}
}
