% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv-plmm.R
\name{cv_plmm}
\alias{cv_plmm}
\title{Cross-validation for plmm}
\usage{
cv_plmm(
  design,
  K = NULL,
  diag_K = NULL,
  eta_star = NULL,
  penalty = "lasso",
  type = "blup",
  gamma,
  alpha = 1,
  lambda_min,
  nlambda = 100,
  lambda,
  eps = 1e-04,
  max_iter = 10000,
  convex = TRUE,
  dfmax = NULL,
  warn = TRUE,
  init = NULL,
  cluster,
  nfolds = 5,
  seed,
  fold = NULL,
  returnY = FALSE,
  returnBiasDetails = FALSE,
  trace = FALSE,
  save_rds = NULL,
  save_fold_res = FALSE,
  return_fit = TRUE,
  compact_save = FALSE,
  ...
)
}
\arguments{
\item{design}{Design matrix object (as created by \code{create_design()}) or a string with the file path to a design object (the file path must end in '.rds').}

\item{K}{Similarity matrix used to rotate the data. This should either be (1) a known matrix that reflects the covariance of y, (2) an estimate (Default is \eqn{\frac{1}{p}(XX^T)}), or (3) a list with components 'd' and 'u', as returned by choose_k().}

\item{diag_K}{Logical: should K be a diagonal matrix? This would reflect observations that are unrelated, or that can be treated as unrelated. Defaults to FALSE.
Note: plmm() does not check to see if a matrix is diagonal. If you want to use a diagonal K matrix, you must set diag_K = TRUE.}

\item{eta_star}{Optional argument to input a specific eta term rather than estimate it from the data. If K is a known covariance matrix that is full rank, this should be 1.}

\item{penalty}{The penalty to be applied to the model. Either "lasso" (the default), "SCAD", or "MCP".}

\item{type}{A character argument indicating what should be returned from predict.plmm(). If type == 'lp', predictions are
based on the linear predictor, X beta. If type == 'blup', predictions are based on the sum of the linear predictor
and the estimated random effect (BLUP). Defaults to 'blup', as this has shown to be a superior prediction method
in many applications.}

\item{gamma}{The tuning parameter of the MCP/SCAD penalty (see details). Default is 3 for MCP and 3.7 for SCAD.}

\item{alpha}{Tuning parameter for the Mnet estimator which controls the relative contributions from the MCP/SCAD penalty and the ridge, or L2 penalty. alpha=1 is equivalent to MCP/SCAD penalty, while alpha=0 would be equivalent to ridge regression. However, alpha=0 is not supported; alpha may be arbitrarily small, but not exactly 0.}

\item{lambda_min}{The smallest value for lambda, as a fraction of lambda.max. Default is .001 if the number of observations is larger than the number of covariates and .05 otherwise.}

\item{nlambda}{Length of the sequence of lambda. Default is 100.}

\item{lambda}{A user-specified sequence of lambda values. By default, a sequence of values of length nlambda is computed, equally spaced on the log scale.}

\item{eps}{Convergence threshold. The algorithm iterates until the RMSD for the change in linear predictors for each coefficient is less than eps. Default is \code{1e-4}.}

\item{max_iter}{Maximum number of iterations (total across entire path). Default is 10000.}

\item{convex}{(future idea; not yet incorporated) Calculate index for which objective function ceases to be locally convex? Default is TRUE.}

\item{dfmax}{(future idea; not yet incorporated) Upper bound for the number of nonzero coefficients. Default is no upper bound. However, for large data sets, computational burden may be heavy for models with a large number of nonzero coefficients.}

\item{warn}{Return warning messages for failures to converge and model saturation? Default is TRUE.}

\item{init}{Initial values for coefficients. Default is 0 for all columns of X.}

\item{cluster}{cv_plmm() can be run in parallel across a cluster using the parallel package. The cluster must be set up in
advance using parallel::makeCluster(). The cluster must then be passed to cv_plmm().}

\item{nfolds}{The number of cross-validation folds. Default is 5.}

\item{seed}{You may set the seed of the random number generator in order to obtain reproducible results.}

\item{fold}{Which fold each observation belongs to. By default, the observations are randomly assigned.}

\item{returnY}{Should cv_plmm() return the linear predictors from the cross-validation folds? Default is FALSE; if TRUE,
this will return a matrix in which the element for row i, column j is the fitted value for observation i from
the fold in which observation i was excluded from the fit, at the jth value of lambda.}

\item{returnBiasDetails}{Logical: should the cross-validation bias (numeric value) and loss (n x p matrix) be returned? Defaults to FALSE.}

\item{trace}{If set to TRUE, inform the user of progress by announcing the beginning of each CV fold. Default is FALSE.}

\item{save_rds}{Optional: if a filepath and name \emph{without} the '.rds' suffix is specified (e.g., \code{save_rds = "~/dir/my_results"}), then the model results are saved to the provided location (e.g., "~/dir/my_results.rds").
Defaults to NULL, which does not save the result.}

\item{save_fold_res}{Optional: a logical value indicating whether the results (loss and predicted values) from each CV fold should be saved?
If TRUE, then two '.rds' files will be saved ('loss' and 'yhat') will be created in the same directory as 'save_rds'.
Both files will be updated after each fold is done.
Defaults to FALSE.}

\item{return_fit}{Optional: a logical value indicating whether the fitted model should be returned as a \code{plmm} object in the current (assumed interactive) session. Defaults to TRUE.}

\item{compact_save}{Optional: if TRUE, three separate .rds files will saved: one with the 'beta_vals', one with 'K', and one with everything else (see below).
Defaults to FALSE. \strong{Note}: you must specify \code{save_rds} for this argument to be called.}

\item{...}{Additional arguments to \code{plmm_fit}}
}
\value{
a list with 12 items:
\itemize{
\item type: the type of prediction used ('lp' or 'blup')
\item cve: numeric vector with the cross validation error (CVE) at each value of \code{lambda}
\item cvse: numeric vector with the estimated standard error associated with each value of for \code{cve}
\item fold: numeric \code{n} length vector of integers indicating the fold to which each observation was assigned
\item lambda: numeric vector of \code{lambda} values
\item fit: the overall fit of the object, including all predictors; this is a
list as returned by \code{plmm()}
\item min: The index corresponding to the value of \code{lambda} that minimizes \code{cve}
\item lambda_min: The \code{lambda} value at which \code{cve} is minmized
\item min1se: The index corresponding to the value of \code{lambda} within
standard error of that which minimizes \code{cve}
\item lambda1se: largest value of lambda such that error is within 1 standard error of the minimum.
\item null.dev: numeric value representing the deviance for the
intercept-only model. If you have supplied your own \code{lambda} sequence,
this quantity may not be meaningful.
\item estimated_Sigma: an n x n matrix representing the estimated covariance matrix.
}
}
\description{
Performs k-fold cross validation for lasso-, MCP-, or SCAD-penalized
linear mixed models over a grid of values for the regularization parameter \code{lambda}.
}
\examples{
admix_design <- create_design(X = admix$X, outcome_col = admix$y)
cv_fit <- cv_plmm(design = admix_design, return_fit = TRUE)
print(summary(cv_fit))
plot(cv_fit)

# Note: for examples with filebacked data, see the filebacking vignette
# https://pbreheny.github.io/plmmr/articles/filebacking.html


}
