% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_multi_raster.R
\name{geom_multi_raster}
\alias{geom_multi_raster}
\title{Geom Layer for Drawing Multiple Rasters}
\usage{
geom_multi_raster(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, flip = FALSE, ...)
}
\arguments{
\item{mapping}{aes mapping.}

\item{data}{data. It should be a tbl object.}

\item{stat}{stat.}

\item{position}{position.}

\item{na.rm}{logical, whether to remove NA values.}

\item{show.legend}{This will not be used 
because the layer does not 
create any legend.}

\item{inherit.aes}{logical, 
whether to inherit aes from ggplot().}

\item{flip}{see description.}

\item{...}{additional parameters.}
}
\description{
Unlike \code{annotation_raster} which 
draws only 1 raster, this layer 
draws one or more rasters at the same time. 
The data must be a tbl object created by 
package tibble and the reason is that, 
as we must give each rectangle a 
vector of colors, the column that 
contains these vectors of colors must 
be a list rather than a vector. A list can 
be a column for tbl object, not for 
a normal data frame. See examples.
Accepted properties are: 
\itemize{
  \item (1) \code{xmin}.
  \item (2) \code{xmax}.
  \item (3) \code{ymin}.
  \item (4) \code{ymax}.
  \item (5) \code{raster}. a list with 1 or more 
rasters. If you have only 1 raster, you also 
have to put it into a list. 
Each raster should be 
a matrix, a raster object, a character vector 
or a magick object read into R by 
\code{magick::image_read}. 
You can also use a data frame created by 
package tibble to combine
\code{xmin, xmax, ymin, ymax, raster}.
  \item (6) \code{interpolate}. It is the same 
as that in \code{annotation_raster} except 
that the default value is TRUE. It can be 
used either inside or outside 
the \code{aes(...)} function. Its length must be 
either 1 or the same as the number of 
rasters.
  \item (7) \code{flip}. The default is FALSE. 
You only need to use TRUE when you 
use \code{coord_flip}. Used outside the 
\code{aes(...)} function.
}
}
\examples{
# Example 1: use vectors and a list. 
mycolor=list(
	c1=matrix(c("red", "blue", "green", "yellow"), nrow=2), 
	c2=matrix(c("green", "yellow")), 
	c3=matrix(c("purple", "red")))
xmin=1: 3
xmax=(1: 3)+0.8 
ymin=c(0, 1, 2)
ymax=c(1, 3, 5)
ggplot()+
	geom_multi_raster(aes(xmin=xmin, xmax=xmax, 
	ymin=ymin, ymax=ymax, raster=mycolor))
#
# Example 2: the same as example 1
# except flip=TRUE.
ggplot()+coord_flip()+
	geom_multi_raster(aes(xmin=xmin, xmax=xmax, 
	ymin=ymin, ymax=ymax, raster=mycolor), flip=TRUE)
}
