% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetplot.R
\name{PrepareUpsetData}
\alias{PrepareUpsetData}
\alias{UpsetPlot}
\title{Upset Plot}
\usage{
PrepareUpsetData(
  data,
  in_form = NULL,
  group_by = NULL,
  group_by_sep = "_",
  id_by = NULL,
  specific = TRUE
)

UpsetPlot(
  data,
  in_form = NULL,
  split_by = NULL,
  split_by_sep = "_",
  group_by = NULL,
  group_by_sep = "_",
  id_by = NULL,
  label = TRUE,
  label_fg = "black",
  label_size = NULL,
  label_bg = "white",
  label_bg_r = 0.1,
  palette = "material-indigo",
  palcolor = NULL,
  alpha = 1,
  specific = TRUE,
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  aspect.ratio = 0.6,
  legend.position = "right",
  legend.direction = "vertical",
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame or a list or an UpsetPlotData object.}

\item{in_form}{A character string indicating the datatype of the input data.
Possible values are "long", "wide", "list", "upset" or NULL.
"long" indicates the data is in long format.
"wide" indicates the data is in wide format.
"list" indicates the data is a list.
"upset" indicates the data is a UpsetPlotData object.
NULL indicates the function will detect the datatype of the input data.

A long format data would look like:
\preformatted{
group_by id_by
A        a1
A        a2
B        a1
B        a3
...
}

A wide format data would look like:
\preformatted{
A    B
TRUE TRUE
TRUE FALSE
FALSE TRUE
...
}

A list format data would look like:
\preformatted{
list(A = c("a1", "a2"), B = c("a1", "a3"))
}

An UpsetPlotData object is generated by PrepareUpsetData() would look like:
\preformatted{
group_by
--------
list("A")  # a2
list("B")  # a3
list(c("A", "B"))  # a1
...
}}

\item{group_by}{A character string specifying the column name of the data frame to group the data.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by},
if multiple columns are provided and the in_form is "long".}

\item{id_by}{A character string specifying the column name of the data frame to identify the instances.
Required when \code{group_by} is a single column and data is a data frame.}

\item{specific}{A logical value to show the specific intersections only.
ggVennDiagram, by default, only return the specific subsets of a region. However,
sometimes, we want to show all the overlapping items for two or more sets.
See \url{https://github.com/gaospecial/ggVennDiagram/issues/64} for more details.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{label}{A logical value to show the labels on the bars.}

\item{label_fg}{A character string specifying the color of the label text.}

\item{label_size}{A numeric value specifying the size of the label text.}

\item{label_bg}{A character string specifying the background color of the label.}

\item{label_bg_r}{A numeric value specifying the radius of the background of the label.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A UpsetPlotData object

A ggplot object or wrap_plots object or a list of ggplot objects
}
\description{
\code{PrepareUpsetData} is used to process the input data for Upset plot.
\code{UpsetPlot} is used to plot the processed data.
}
\examples{
data <- list(
    A = 1:5,
    B = 2:6,
    C = 3:7,
    D = 4:8
)
UpsetPlot(data)
UpsetPlot(data, label = FALSE)
UpsetPlot(data, palette = "Reds", specific = FALSE)
}
