% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialplot.R
\name{flip_y_spatraster}
\alias{flip_y_spatraster}
\alias{flip_y_spatvector}
\title{Flip values on the y-axis direction, and negate the Y-Coordinates of SpatRaster and SpatVector Objects}
\usage{
flip_y_spatraster(data)

flip_y_spatvector(data)
}
\arguments{
\item{data}{A \code{SpatRaster} or \code{SpatVector} object from the \code{terra} package.}
}
\value{
For \code{flip_y_spatraster}, a \code{SpatRaster} object with flipped y-coordinates and adjusted extent.
For \code{flip_y_spatvector}, a \code{SpatVector} object with y-coordinates negated.
}
\description{
These internal functions flip the y-coordinates of \code{SpatRaster} and \code{SpatVector} objects from the \code{terra} package.
For rasters, the function vertically flips the raster and adjusts its extent accordingly.
For vectors, the function negates the y-coordinates of all geometries, supporting both point and polygon/line types.
}
\details{
These functions are intended for internal use to facilitate coordinate transformations.
When visualizing spatial data, it is often necessary to flip the y-axis to put the origin at the top left corner.
However, a lot of elements have to be visualized with \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}, which won't work with
\code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_reverse()}}. See also \href{https://github.com/tidyverse/ggplot2/issues/4021#issuecomment-650787582}{this GitHub issue comment}.
So we need these functions to flip the values along the y-axis and negate the y-coordinates.
This way, we can remove the negative sign from the y-axis labels to mimick the behavior of \code{scale_y_reverse()}.#'
}
\keyword{internal}
