% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.plte.R
\name{plte_plot}
\alias{plte_plot}
\title{Plot objects created by plte_builder}
\usage{
plte_plot(obj, t_labels = TRUE)
}
\arguments{
\item{obj}{a \code{plte} class object created by \code{\link{plte_builder}}.}

\item{t_labels}{logical whether or not to include time labels for each point.}
}
\value{
A \code{gg} ggplot2 object that can be modified using the
\code{+} in combination with other ggplot2 functions.
}
\description{
Plot objects created by plte_builder
}
\examples{
data('negative')

# BTSCS set the data
neg_set <- btscs(df = negative, event = 'y', t_var = 'tim',
                 cs_unit = 'group', pad_ts = FALSE)
                 # Create temporal dependence variables
neg_set$t <- neg_set$spell + 1

m1 <- glm(y ~ x + t + I(t^2) + I(t^3),
          family = binomial(link = 'logit'),
          data = neg_set)

counterfactual <- data.frame(x = 0.5)

sim1 <- plte_builder(obj = m1, obj_tvar = 't',
                     cf = counterfactual, t_points = c(13, 25),
                     cf_duration = 4, ci = 99)

# With time point labels
plte_plot(sim1)

# Without time point labels
plte_plot(sim1, t_labels = FALSE)


}
