% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot.pmcalibration}
\alias{plot.pmcalibration}
\title{Plot a calibration curve (\code{pmcalibration} object)}
\usage{
\method{plot}{pmcalibration}(x, conf_level = 0.95, ...)
}
\arguments{
\item{x}{a \code{pmcalibration} calibration curve}

\item{conf_level}{width of the confidence interval (0.95 gives 95\% CI). Ignored if call to \code{pmcalibration} didn't request confidence intervals}

\item{...}{other args for \code{plot()} (\code{lim} and \code{lab} can be specified)}
}
\value{
No return value, called for side effects
}
\description{
This is for a quick and dirty calibration curve plot.
Alternatively you can use \code{get_cc()} to get the data required to plot the calibration curve.
}
\examples{
library(pmcalibration)
# simulate some data with a binary outcome
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)
head(dat)
# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

# fit calibration curve
cal <- pmcalibration(y = dat$y, p = p, smooth = "gam", k = 20, ci = "pw")

plot(cal)
}
