% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_consistency.R
\name{panel_fill}
\alias{panel_fill}
\title{Fill in gaps in panel data}
\usage{
panel_fill(
  .df,
  .set_NA = FALSE,
  .min = NA,
  .max = NA,
  .backwards = FALSE,
  .group_i = TRUE,
  .flag = NA,
  .i = NULL,
  .t = NULL,
  .d = 1,
  .uniqcheck = FALSE,
  .setpanel = TRUE
)
}
\arguments{
\item{.df}{Tibble or data frame which either has the \code{.t} and \code{.d} (and perhaps \code{.i}) attributes included by \code{as_pibble()}, or the appropriate panel structure is declared in the function.}

\item{.set_NA}{Should values in newly-created observations be set to adjacent values or to NA? Set to \code{TRUE} to set all new values to NA except for .i and .t. To make only specific variables NA, list them as a character vector. Defaults to FALSE; all values are filled in using the most recently available data.}

\item{.min}{Sets the first time period in the data for each individual to be \code{.min}, and fills in gaps between period \code{.min} and the actual start of the data. Copies data from the first period present in the data for each individual (if grouped). Handy for creating balanced panels.}

\item{.max}{Sets the last time period in the data for each individual to be \code{.max}, and fills in gaps between period \code{.max} and the actual start of the data. Copies data from the flast period present in the data for each individual (if grouped). Handy for creating balanced panels.}

\item{.backwards}{By default, values of newly-created observations are copied from the most recently available period. Set \code{.backwards = TRUE} to instead copy values from the closest *following* period.}

\item{.group_i}{By default, \code{panel_fill()} will fill in gaps within values of \code{.i}. If \code{.i} is missing, it won't do that. If \code{.i} is in the data and you still don't want \code{panel_fill()} to run within \code{.i}, set \code{.group_i = FALSE}.}

\item{.flag}{The name of a new variable indicating which observations are newly created by \code{panel_fill()}.}

\item{.i}{Quoted or unquoted variables that identify the individual cases. Note that setting any one of \code{.i}, \code{.t}, or \code{.d} will override all three already applied to the data, and will return data that is \code{as_pibble()}d with all three, unless \code{.setpanel=FALSE}.}

\item{.t}{Quoted or unquoted variable indicating the time. \code{pmdplyr} accepts two kinds of time variables: numeric variables where a fixed distance \code{.d} will take you from one observation to the next, or, if \code{.d=0}, any standard variable type with an order. Consider using the \code{time_variable()} function to create the necessary variable if your data uses a \code{Date} variable for time.}

\item{.d}{Number indicating the gap in \code{.t} between one period and the next. For example, if \code{.t} indicates a single day but data is collected once a week, you might set \code{.d=7}. To ignore gap length and assume that "one period ago" is always the most recent prior observation in the data, set \code{.d=0}. By default, \code{.d=1}.}

\item{.uniqcheck}{Logical parameter. Set to \code{TRUE} to always check whether \code{.i} and \code{.t} uniquely identify observations in the data. By default this is set to FALSE and the check is only performed once per session, and only if at least one of \code{.i}, \code{.t}, or \code{.d} is set.}

\item{.setpanel}{Logical parameter. \code{TRUE} by default, and so if \code{.i}, \code{.t}, and/or \code{.d} are declared, will return a \code{pibble} set in that way.}
}
\description{
This function creates new observations to fill in any gaps in panel data. For example, if individual 1 has an observation in periods t = 1 and t = 3 but no others, this function will create an observation for t = 2. By default, the t = 2 observation will be identical to the t = 1 observation except for the time variable, but this can be adjusted. This function returns data sorted by \code{.i} and \code{.t}.
}
\details{
Note that, in the case where there is more than one observation for a given individual/time period (or just time period if \code{.group_i = FALSE}), \code{panel_fill()} will create copies of *every observation* in the appropriate individual/time period for filling-in purposes. So if there are four t = 1 observations and nothing in t = 2, \code{panel_fill()} will create four new observations with t = 2, copying the original four in t = 1.

By default, the \code{panel_fill()} operation is grouped by \code{.i}, although it will return the data in the original grouping structure. Leave \code{.i} blank, or, if \code{.i} is already in the data from \code{as_pibble}, set \code{.group_i=FALSE} to run the function ungrouped, or with the existing group structure.

This function requires \code{.t} and \code{.d} to be declared in the function or already established in the data by \code{as_pibble()}. Also, this requires a cardinal \code{.t}. It must not be the case that \code{.d=0}.
}
\examples{

# Examples are too slow to run - this function is slow!
if (interactive()) {
  data(Scorecard)
  # Notice that, in the Scorecard data, the gap between one year and the next is not always constant
  table((Scorecard \%>\% dplyr::arrange(year) \%>\%
    dplyr::group_by(unitid) \%>\%
    dplyr::mutate(diff = year - dplyr::lag(year)))$diff)
  # And also that not all universities show up for the first or last times in the same year
  year_range <- Scorecard \%>\%
    dplyr::group_by(unitid) \%>\%
    dplyr::summarize(first_year = min(year), last_year = max(year))
  table(year_range$first_year)
  table(year_range$last_year)
  rm(year_range)

  # We can deal with the inconsistent-gaps problem by creating new obs to fill in
  # this version will fill in the new obs with the most recently observed data, and flag them
  Scorecard_filled <- panel_fill(Scorecard,
    .i = unitid,
    .t = year,
    .flag = "new"
  )

  # Or maybe we want those observations in there but don't want to treat them as real data
  # so instead of filling them in, just leave all the data in the new obs blank
  # (note this sets EVERYTHING not in .i or .t to NA - if you only want some variables NA,
  # make .set_NA a character vector of those variable names)
  Scorecard_filled <- panel_fill(Scorecard,
    .i = unitid,
    .t = year,
    .flag = "new",
    .set_NA = TRUE
  )

  # Perhaps we want a perfectly balanced panel. So let's set .max and .min to the start and end
  # of the data, and it will fill in everything.
  Scorecard_filled <- panel_fill(Scorecard,
    .i = unitid, .t = year, .flag = "new",
    .min = min(Scorecard$year), .max = max(Scorecard$year)
  )
  # how many obs of each college? Should be identical, and equal to the number of years there are
  table(table(Scorecard_filled$unitid))
  length(unique(Scorecard_filled$year))
}
}
