% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.ARIMA.R
\name{pmml.ARIMA}
\alias{pmml.ARIMA}
\title{Generate PMML for an ARIMA object the \bold{forecast} package.}
\usage{
\method{pmml}{ARIMA}(
  model,
  model_name = "ARIMA_model",
  app_name = "SoftwareAG PMML Generator",
  description = "ARIMA Time Series Model",
  copyright = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  exact_least_squares = TRUE,
  ...
)
}
\arguments{
\item{model}{An ARIMA object from the package \pkg{forecast}.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{exact_least_squares}{(seasonal models only) If TRUE, export with exact least squares;
otherwise, use conditional least squares.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the \code{ARIMA} object.
}
\description{
Generate PMML for an ARIMA object the \bold{forecast} package.
}
\details{
The model is represented in the PMML TimeSeriesModel format.
Non-seasonal models are represented with conditional
least squares. For models with a seasonal component, the PMML can be exported with conditional
least squares or exact least squares. Note that ARIMA models in R are
estimated using a state space formulation. When using conditional least squares with seasonal models,
forecast results between R and PMML may not match.

Prediction intervals are exported for non-seasonal models only. For ARIMA models with d=2, the intervals
between R and PMML may not match.

Transforms are currently not supported for ARIMA models.
}
\examples{
library(forecast)

# non-seasonal model
data("WWWusage")
mod <- Arima(WWWusage, order = c(3, 1, 1))
mod_pmml <- pmml(mod)

# seasonal model
data("JohnsonJohnson")
mod_02 <- Arima(JohnsonJohnson,
  order = c(1, 1, 1),
  seasonal = c(1, 1, 1)
)
mod_02_pmml <- pmml(mod_02)
}
\author{
Dmitriy Bolotov
}
