% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_derived_2cpt.R
\name{calc_derived_2cpt}
\alias{calc_derived_2cpt}
\title{Calculate derived pharmacokinetic parameters for a 2-compartment linear model}
\usage{
calc_derived_2cpt(CL, V1, V2, Q, type = "all", sigdig = 5)
}
\arguments{
\item{CL}{Clearance (L/h)}

\item{V1}{Central volume of distribution (L)}

\item{V2}{Peripheral volume of distribution (L)}

\item{Q}{Intercompartmental clearance (L/h)}

\item{type}{Type of half-life to return (\code{"Vss"}, \code{"k10"}, \code{"k12"}, \code{"k21"}, \code{"thalf_alpha"}, \code{"thalf_beta"}, \code{"alpha"}, \code{"beta"}, \code{"trueA"}, \code{"trueB"}, \code{"fracA"}, \code{"fracB"}, \code{"all"}). Default is \code{"all"}).}

\item{sigdig}{Number of significant digits to be returned. Default is 5.}
}
\value{
Return a list of derived PK parameters for a 2-compartment linear model given provided clearances and volumes.
\itemize{ 
  \item \code{Vss}: Volume of distribution at steady state, \eqn{V_{ss}} (L)
  \item \code{k10}: First-order elimination rate, \eqn{k_{10}} (/h)
  \item \code{k12}: First-order rate of transfer from central to peripheral compartment, \eqn{k_{12}} (/h)
  \item \code{k21}: First-order rate of transfer from peripheral to central compartment, \eqn{k_{21}} (/h)   
  \item \code{thalf_alpha}: Distributional half-life, \eqn{t_{1/2,\alpha}} (h)
  \item \code{thalf_beta}: Terminal half-life, \eqn{t_{1/2,\beta}} (h)
  \item \code{alpha}: \eqn{\alpha}
  \item \code{beta}: \eqn{\beta}
  \item \code{trueA}: true A
  \item \code{trueB}: true B
  \item \code{fracA}: fractional A
  \item \code{fracB}: fractional B
 }
}
\description{
Calculate derived pharmacokinetic parameters for a 2-compartment linear model
}
\examples{
params <- calc_derived_2cpt(CL=16, V1=25, V2=50, Q=0.5)

}
\references{
Shafer S. L. \code{CONVERT.XLS}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
