% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nmprogress.R
\name{plot_nmprogress}
\alias{plot_nmprogress}
\title{Plot NONMEM parameter estimation by iteration.}
\usage{
plot_nmprogress(fileName, fileExt = ".lst", metric = "perc",
  lineCol = "#902C10", idlineCol = "black")
}
\arguments{
\item{fileName}{A NONMEM output file prefix, without extension (e.g. 'run315').}

\item{fileExt}{The file extension for NONMEM output, set to '.lst' by default.}

\item{metric}{What to show in the plot. Allowed options are 'est' (the actual 
estimate) or 'perc' (the percentage change in the estimated or OFV since estimation began). 
Default is 'perc'.}

\item{lineCol}{Line color. Default is '#902C10'.}

\item{idlineCol}{Identity line color (only used if 'perc' metric is selected). Default is black.}
}
\value{
A set of plots.
}
\description{
\code{plot_nmprogress} returns a plot or set of plots showing the evolution of 
parameter estimates by iteration.
}
\examples{
\dontrun{
plot_nmprogress("run315")
plot_nmprogress("run315", ".nmlst")
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
