% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnm.R
\name{rnm}
\alias{rnm}
\title{Read NONMEM 7.2+ output into an R object.}
\usage{
rnm(
  index,
  prefix = "run",
  pathNM,
  ndig = 3,
  ndigB = 3,
  ndigP = 1,
  Pci = 95,
  ext = ".lst",
  extmod = ".mod",
  Pvalues = TRUE,
  RawCI = FALSE,
  ...
)
}
\arguments{
\item{index}{The NONMEM model index, i.e. the numeric part of the filename assuming it follows the convention 'run123.mod'.}

\item{prefix}{The NONMEM model prefix, assuming it follows the convention 'run123.mod'. The default is \code{"run"}.}

\item{pathNM}{The path to the NONMEM output. This should not contain a trailing slash.}

\item{ndig}{Number of significant digits to use. The default is 3.}

\item{ndigB}{Number of significant digits to use. The default is 3.}

\item{ndigP}{Number of digits after the decimal point to use for percentages. The default is 1.}

\item{Pci}{Asymptotic confidence interval to apply when reporting parameter uncertainty. The default is 95.}

\item{ext}{NONMEM output file extension. The default is \code{".lst"}.}

\item{extmod}{NONMEM control stream file extension. The default is \code{"mod"}.}

\item{Pvalues}{Report P-values for parameters? The default is \code{TRUE}.}

\item{RawCI}{Report confidence intervals without estimate? The default is \code{FALSE}.}

\item{...}{Additional arguments.}
}
\value{
A list containing information extracted from the NONMEM output.
}
\description{
Read NONMEM 7.2+ output into an R object.
}
\details{
The output list is composed of the following objects:
\itemize{
 \item{"Theta"}{A data frame describing the structural (fixed-effect) parameters, containing parameter name, estimated value, standard error (SE), coefficient of variation (CV), lower and upper confidence limits (CIL and CIU, based on \code{Pci}), and P-value, calculated as \code{2 * (1 - pnorm(abs(theta/theta.se)))}.}
 \item{"Eta"}{A data frame describing the interindividual random-effects parameters, containing estimated value, standard error (SE), coefficient of variation (CV, calculated as \code{abs(100*(SE/OMEGA))}), coefficient of variation (EtaCV, calculated as \code{100*sqrt(OMEGA)}), and shrinkage.}
 \item{"Epsilon"}{A data frame describing the residual random-effects parameters, containing estimated value, standard error (SE), coefficient of variation (CV, calculated as \code{abs(100*(SE/OMEGA))}), coefficient of variation (EtaCV, calculated as \code{100*sqrt(SIGMA)}), and shrinkage.}
 \item{"CorTheta"}{A data frame containing the correlation matrix for fixed effects (\code{"THETA"}).}
 \item{"CorOmega"}{A data frame containing the correlation matrix for interindividual random effects (\code{"OMEGA"}).}
 \item{"CorSigma"}{A data frame containing the correlation matrix for residual random effects (\code{"OMEGA"}).}
 \item{"OmegaMatrix"}{A data frame containing the \code{"OMEGA"} matrix.}
 \item{"SigmaMatrix"}{A data frame containing the \code{"OMEGA"} matrix.}
 \item{"CovMatrixTheta"}{A data frame containing the variance-covariance matrix for structural parameters (\code{THETA}).}
 \item{"CovMatrix"}{A data frame containing the complete variance-covariance matrix.}
 \item{"OFV"}{The objective function value.}
 \item{"ThetaString"}{A data frame containing all relevant fixed-effects parameter information, suitable for use in a table of parameter estimates. Contains parameter name, estimate, standard error, coefficient of variation, combined estimate and asymptotic confidence interval, and P-value.}
 \item{"EtaString"}{A data frame containing all relevant interindivudal random-effects parameter information, suitable for use in a table of parameter estimates. Contains parameter name, estimate (variance), standard error, coefficient of variation, percentage value (calculated as \code{100*sqrt(OMEGA)}), and shrinkage.}
 \item{"EpsString"}{A data frame containing all relevant residual random-effects parameter information, suitable for use in a table of parameter estimates. Contains parameter name, estimate (variance), standard error, coefficient of variation, percentage value (calculated as \code{100*sqrt(SIGMA)}), and shrinkage.}
 \item{"RunTime"}{Run time.}
 \item{"ConditionN"}{Condition number.}
 
 
}
}
\examples{
\dontrun{
nmOutput <- rnm("run315.lst")
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Rik Schoemaker, \email{rik.schoemaker@occams.com}

Justin Wilkins, \email{justin.wilkins@occams.com}
}
