% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSimulator.R
\name{ModelSimulator}
\alias{ModelSimulator}
\title{R6 class representing a model simulator.}
\description{
\code{\link[R6:R6Class]{R6}} class for running individual model simulations via a
simulation function, storing results, and generating success/error statuses.
}
\examples{
# Simulation model
model1 <- SimulationModel$new(
  time_steps = 10,
  model_attributes = c("time_steps", "a", "b"),
  params = list(a = 1:7)
)
model1$required_attributes <- model1$model_attributes
# Simulation function
test_simulator <- function(model) {
  sum(unlist(model$get_attributes(model$required_attributes)))
}
# Model simulator
simulator1 <- ModelSimulator$new(
  simulation_model = model1,
  simulation_function = test_simulator
)
simulator1$run()
model1$set_attributes(a = 1:10, b = 15)
model1$get_attributes(model1$required_attributes)
simulator1$run()
simulator1$results

}
\section{Super class}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{ModelSimulator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{simulation_model}}{A SimulationModel object or an inherited class object.}

\item{\code{simulation_function}}{Name (character string) or direct assignment (assigned or loaded via source path) of the simulation function, which takes a \code{\link{SimulationModel}} (or inherited class) as an input and returns the simulation results.}

\item{\code{sample_id}}{An identifier for the simulation sample.}

\item{\code{results}}{A list of result structures.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ModelSimulator-new}{\code{ModelSimulator$new()}}
\item \href{#method-ModelSimulator-new_clone}{\code{ModelSimulator$new_clone()}}
\item \href{#method-ModelSimulator-get_attribute}{\code{ModelSimulator$get_attribute()}}
\item \href{#method-ModelSimulator-run}{\code{ModelSimulator$run()}}
\item \href{#method-ModelSimulator-clone}{\code{ModelSimulator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelSimulator-new"></a>}}
\if{latex}{\out{\hypertarget{method-ModelSimulator-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets the population model, and optionally the simulation function, the sample ID, and any attached attributes listed individually.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelSimulator$new(
  simulation_model = NULL,
  simulation_function = NULL,
  sample_id = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simulation_model}}{A \code{\link{SimulationModel}} (or inherited class) object (can be set later).}

\item{\code{simulation_function}}{Optional name (character string) or direct assignment (assigned or loaded via source path) of the simulation function, which takes a \code{\link{SimulationModel}} (or inherited class) as an input and returns the simulation results.}

\item{\code{sample_id}}{Optional identifier for the simulation sample.}

\item{\code{...}}{Additional parameters passed individually are attached.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelSimulator-new_clone"></a>}}
\if{latex}{\out{\hypertarget{method-ModelSimulator-new_clone}{}}}
\subsection{Method \code{new_clone()}}{
Creates a new (re-initialized) object of the current (inherited) object class with optionally passed parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelSimulator$new_clone(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed via the inherited class constructor (defined in initialize and run via new).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New object of the current (inherited) class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelSimulator-get_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-ModelSimulator-get_attribute}{}}}
\subsection{Method \code{get_attribute()}}{
Returns selected named simulator or attached attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelSimulator$get_attribute(param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{Name of the parameter/attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Selected parameter/attribute value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelSimulator-run"></a>}}
\if{latex}{\out{\hypertarget{method-ModelSimulator-run}{}}}
\subsection{Method \code{run()}}{
Runs a model simulator (function), stores the results, and creates a status log entry as a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelSimulator$run()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list representing a simulation log entry with a \emph{successful} boolean and a status message template (with a placeholder for the sample identifier).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelSimulator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ModelSimulator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelSimulator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
