% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_disk_multiagent.R
\name{read_disk_multiagent}
\alias{read_disk_multiagent}
\title{Read \strong{pointblank} \emph{agents} stored on disk as a \emph{multiagent}}
\usage{
read_disk_multiagent(filenames = NULL, pattern = NULL, path = NULL)
}
\arguments{
\item{filenames}{\emph{File names}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

The names of files (holding \emph{agent} objects) that were previously written
by \code{\link[=x_write_disk]{x_write_disk()}}.}

\item{pattern}{\emph{Regex pattern}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A regex pattern for accessing saved-to-disk \emph{agent} files located in a
directory (specified in the \code{path} argument).}

\item{path}{\emph{File path}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A path to a collection of files. This is either optional in the case that
files are specified in \code{filenames} (the \code{path} combined with all
\code{filenames}), or, required when providing a \code{pattern} for file names.}
}
\value{
A \code{ptblank_multiagent} object.
}
\description{
An \emph{agent} or \emph{informant} can be written to disk with the \code{\link[=x_write_disk]{x_write_disk()}}
function. While useful for later retrieving the stored agent with
\code{\link[=x_read_disk]{x_read_disk()}} it's also possible to read a series of on-disk agents with
the \code{read_disk_multiagent()} function, which creates a \code{ptblank_multiagent}
object. A \emph{multiagent} object can also be generated via the
\code{\link[=create_multiagent]{create_multiagent()}} function but is less convenient to use if one is just
using agents that have been previously written to disk.
}
\section{Function ID}{

10-2
}

\seealso{
Other The multiagent: 
\code{\link{create_multiagent}()},
\code{\link{get_multiagent_report}()}
}
\concept{The multiagent}
