% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_tabular}
\alias{info_tabular}
\title{Add information that focuses on aspects of the data table as a whole}
\usage{
info_tabular(x, ...)
}
\arguments{
\item{x}{An informant object of class \code{ptblank_informant}.}

\item{...}{Information entries as a series of named arguments. The names
refer to subsection titles within the \code{TABLE} section and the RHS is the
\emph{info text} (informational text that can be written as Markdown and further
styled with \emph{Text Tricks}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
When an \emph{informant} object is created with the \code{\link[=create_informant]{create_informant()}} function,
it has two starter sections: (1) 'table' and (2) 'columns'. The
'table' section should contain a few properties upon creation, such as the
supplied table name (\code{name}) and table dimensions (as \verb{_columns} and
\verb{_rows}). We can add more table-based properties with the \code{info_tabular()}
function. By providing a series of named arguments (in the form
\code{entry_name = "The *info text*."}), we can add more information that makes
sense for describing the table as a whole.
}
\details{
The \emph{info text} readily accepts Markdown formatting. Also, there are a few
\emph{Text Tricks} that are good to know. Markdown links written as \verb{< link url >}
or \verb{[ link text ]( link url )} will get nicely-styled links. Any dates
expressed in the ISO-8601 standard with parentheses, \code{"(2004-12-01)"}, will
be styled with a font variation (monospaced) and underlined in purple. Spans
of text can be converted to label text by using: (1) double parentheses
around text for a rectangular label as in \verb{((label text))}, or (2) triple
parentheses around text for a rounded-rectangular label like \verb{(((label text)))}. Finally, CSS styles can be applied to spans of \emph{info text} with
the following form:

\verb{[[ info text ]]<< CSS style rules >>}

As an example of this in practice suppose you'd like to change the color of
some text to red and make the font appear somewhat thinner. A variation on
the following might be used:

\code{"This is a [[factor]]<<color: red; font-weight: 300;>> value."}
}
\section{Figures}{

\if{html}{\figure{man_info_tabular_1.png}{options: width=100\%}}
}

\section{Function ID}{

3-1
}

\examples{
# Create a pointblank `informant`
# object with `create_informant()`;
# we specify a `read_fn` with the
# `~` followed by a statement that
# gets the `small_table` dataset
informant <- 
  create_informant(
    read_fn = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  )

# The `informant` object has the 'table'
# and 'columns' sections; we can add more
# properties to the 'table' section
informant <-
  informant \%>\%
  info_tabular(
    row_definition = "A row has randomized values.",
    source = c(
      "- From the **pointblank** package.",
      "- [https://rich-iannone.github.io/pointblank/]()"
     )
   )

# Upon printing the `informant` object, we see
# the additions made to the 'Table' section

# The `informant` object can be written to
# a YAML file with the `yaml_write()`
# function; then information can
# be directly edited or modified
# yaml_write(
#   informant = informant,
#   filename = "informant.yml"
# )

# The YAML file can then be read back
# into an informant object with the
# `yaml_read_informant()` function
# informant <-
#   yaml_read_informant(path = "informant.yml")

}
\seealso{
Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()}
}
\concept{Information Functions}
