% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_informant.R
\name{yaml_read_informant}
\alias{yaml_read_informant}
\title{Read a \strong{pointblank} YAML file to create an \emph{informant} object}
\usage{
yaml_read_informant(filename, path = NULL)
}
\arguments{
\item{filename}{The name of the YAML file that contains fields related to an
\emph{informant}.}

\item{path}{An optional path to the YAML file (combined with \code{filename}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
With \code{yaml_read_informant()} we can read a \strong{pointblank} YAML file that
describes table information (typically generated by the \code{\link[=yaml_write]{yaml_write()}}
function. What's returned is a new \emph{informant} object with the information
intact. The \emph{informant} object can be given more information through use of
the \verb{info_*()} functions.
}
\section{Function ID}{

11-3
}

\examples{
if (interactive()) {

# Create a pointblank `informant`
# object with `create_informant()`
# and the `small_table` dataset
informant <- create_informant(small_table)

# An `informant` object can be written
# to a YAML file with the `yaml_write()`
# function
# yaml_write(
#   informant = informant,
#   filename = "informant-small_table.yml"
# )

# The `informant-small_table.yml` file
# looks like this when written

#> info_label: '[2020-09-06|13:37:38]'
#> table:
#>   name: small_table
#> _columns: 8
#> _rows: 13
#> _type: tbl_df
#> columns:
#>   date_time:
#>     _type: POSIXct, POSIXt
#>   date:
#>     _type: Date
#>   a:
#>     _type: integer
#>   b:
#>     _type: character
#>   c:
#>     _type: numeric
#>   d:
#>     _type: numeric
#>   e:
#>     _type: logical
#>   f:
#>     _type: character

# We can add keys and values to
# add more pertinent information; with
# some direct editing of the file we get:

#> info_label: '[2020-09-06|13:37:38]'
#> table:
#>   name: small_table
#>   _columns: 8
#>   _rows: 13
#>   _type: tbl_df
#> columns:
#>   date_time:
#>     _type: POSIXct, POSIXt
#>     info: Date-time values.
#>   date:
#>     _type: Date
#>     info: Date values (the date part of `date_time`).
#>   a:
#>     _type: integer
#>     info: Small integer values (no missing values).
#>   b:
#>     _type: character
#>     info: Strings with a common pattern.
#>   c:
#>     _type: numeric
#>     info: Small numeric values (contains missing values).
#>   d:
#>     _type: numeric
#>     info: Large numeric values (much greater than `c`).
#>   e:
#>     _type: logical
#>     info: TRUE and FALSE values.
#>   f:
#>     _type: character
#>     info: Strings of the set `"low"`, `"mid"`, and `"high"`.

# We could also have done the same
# with the `informant` object by use of
# the `info_columns()` function

# The 'informant-small_table.yml' file
# is available in the package through
# `system.file()`
yml_file <- 
  system.file(
    "yaml", "informant-small_table.yml",
    package = "pointblank"
  )

# We can read this YAML file back
# as an `informant` object by using
# `yaml_read_informant()`
informant <- 
  yaml_read_informant(filename = yml_file)

class(informant)

}

}
\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
