% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language_codes-dataset.R
\docType{data}
\name{language_codes}
\alias{ALLOWED_LANGUAGE_REGEX}
\alias{language_codes}
\title{Language codes supported by GNU gettext}
\format{\code{language_codes} is a list with two character vector elements.
\describe{
\item{language}{Lowercase two letter ISO 639-1 codes, and some lowercase
three letter ISO 639-2 codes representing languages.}
\item{country}{Uppercase two letter ISO 3166-1 alpha-2 code representing
countries and territories.}
}}
\usage{
data(language_codes)

ALLOWED_LANGUAGE_REGEX
}
\description{
This dataset contains the language and country code values that are accepted
by GNU gettext. Its primary purpose is to allow checking of the "Language"
field of PO translation files.
}
\details{
Valid "Language" field values consist of a language code taken from the
\code{usual_lang} or \code{rare_lang} elements of this dataset, optionally
followed by an underscore and a country code taken from the \code{country}
element of this dataset.
}
\note{
The \code{language} element of the dataset contains all of ISO 639-1 as
well as the value "mo", for "Moldavian", which isn't an official ISO code.
It also contains a subset of ISO 639-2, for rare languages where there is
no ISO 629-1 code.
The \code{country} element is identical to ISO 3166-1 alpha-2.
}
\examples{
# The dataset contains:
e <- new.env()
utils::data(language_codes, package = "poio", envir = e)
e$language_codes

# Allowed values in the language field can be matched like this
# (though it will be automatically done in generate_po_from_pot)
stringi::stri_detect_regex(c("it", "nl_BE", "xxx"), ALLOWED_LANGUAGE_REGEX)
}
\references{
The dataset was generated from these the contents of these
webpages:
\url{https://www.gnu.org/software/gettext/manual/html_node/Usual-Language-Codes.html#Usual-Language-Codes}
\url{https://www.gnu.org/software/gettext/manual/html_node/Rare-Language-Codes.html#Rare-Language-Codes}
\url{https://www.gnu.org/software/gettext/manual/html_node/Country-Codes.html#Country-Codes}
}
\keyword{datasets}

