% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{poisson.llk}
\alias{poisson.llk}
\title{Evaluate Poisson log-likelihood for counts matrix}
\usage{
poisson.llk(model, X_test, full_llk = FALSE, include_missing = FALSE)
}
\arguments{
\item{model}{A Poisson factorization model object as returned by `poismf`.}

\item{X_test}{Input data on which to calculate log-likelihood, consisting of triplets.
Can be passed as a `data.frame` or as a sparse COO/triplets matrix (class `Matrix::dgTMatrix` or
`SparseM::matrix.coo`). If the `X` data passed to
`poismf` was a `data.frame`, should pass a `data.frame` with entries corresponding
to the same IDs, otherwise might pass either a `data.frame` with the row and column
indices (starting at 1), or a sparse COO matrix.}

\item{full_llk}{Whether to add to the number a constant given by the data which doesn't
depend on the fitted parameters. If passing `False` (the default), there
is some chance that the resulting log-likelihood will end up being
positive - this is not an error, but is simply due to ommission of this
constant. Passing `TRUE` might result in numeric overflow and low
numerical precision.}

\item{include_missing}{If `TRUE`, will calculate the Poisson log-likelihood for all entries
(i.e. all combinations of users/items, whole matrix `X`),
taking the missing ones as zero-valued. If passing `FALSE`, will
calculate the Poisson log-likelihood only for the non-missing entries
passed in `X_test` - this is usually the desired behavior when
evaluating a test dataset.}
}
\value{
Obtained Poisson log-likelihood (higher is better).
}
\description{
Calculates Poisson log-likehood plus constant for new combinations
of rows and columns of `X`. Intended to use as a test metric or for monitoring a validation set.

By default, this Poisson log-likelihood is calculated only for the combinations
of users (rows) and items (columns) provided in `X_test` here, ignoring the
missing entries. This is the usual use-case for evaluating a validation or test
set, but can also be used for evaluating it on the training data with all
missing entries included as zeros (see parameters for details).

Note that this calculates a \bold{sum} rather than an average.
}
\details{
If using more than 1 thread, the results might vary slightly between runs.
}
\seealso{
\link{poismf}
}
