% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rip.R
\name{rip}
\alias{rip}
\title{Polite file download}
\usage{
rip(
  bow,
  destfile = NULL,
  ...,
  mode = "wb",
  path = tempdir(),
  overwrite = FALSE
)
}
\arguments{
\item{bow}{host introduction object of class \code{polite}, \code{session} created by \code{bow()} or \code{nod()}}

\item{destfile}{optional new file name to use when saving the file. If missing, it will be guessed from `basename(url)``}

\item{...}{other parameters passed to \code{download.file}}

\item{mode}{character. The mode with which to write the file. Useful values are \code{w}, \code{wb} (binary), \code{a} (append) and \code{ab}. Not used for methods \code{wget} and \code{curl}.}

\item{path}{character. Path where to save the destfile. By default is temporary directory created with \code{tempdir()}
Ignored if \code{destfile} contains path along with filename.}

\item{overwrite}{if \code{TRUE} will overwrite file on disk}
}
\value{
Full path to the locally saved file indicated by the user in \code{destfile} (and \code{path})
}
\description{
Polite file download
}
\examples{
\donttest{
bow("https://www.cheese.com/") \%>\%
 nod("media/img/sub-page-slide2.jpg") \%>\%
 rip()
}
}
