% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_functions.R
\docType{class}
\name{nuisance_functions}
\alias{nuisance_functions}
\title{Nuisance Functions}
\description{
The fitted g-functions and Q-functions are stored in an object
of class "nuisance_functions". The object is a list with a fitted model
object for every stage. Information on whether the full history or the
state/Markov-type history is stored as an attribute ("full_history").
}
\section{S3 generics}{

The following S3 generic functions are available for an object of class
\code{nuisance_functions}:
\itemize{
\item{\code{predict}}{ Predict the values of the g- or Q-functions based
on a \link{policy_data} object.}
}
}

\examples{
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d <- sim_two_stage(5e2, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# evaluating the static policy a=1:
pe <- policy_eval(policy_data = pd,
                  policy = policy_def(1, reuse = TRUE),
                  g_models = g_glm(),
                  q_models = q_glm())

# getting the fitted g-functions:
(g_functions <- get_g_functions(pe))

# getting the fitted Q-functions:
(q_functions <- get_q_functions(pe))

# getting the fitted values:
head(predict(g_functions, pd))
head(predict(q_functions, pd))
}
