% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/headwidthsize.R
\name{headwidthsize}
\alias{headwidthsize}
\title{Converts pollinator (Diptera, Hymenoptera and Lepidoptera) head width (mm) to body size (dry weight (mg)).}
\usage{
headwidthsize(HW, Eq = "H97DB")
}
\arguments{
\item{HW}{A vector of head width measurements (mm).}

\item{Eq}{a vector of predictive allometries for insect taxa from Hodar (1997). 
Options implemented are: H97DB (Brachycera), H97DN (Nematocera), H97HA (Hymenoptera), H97LH (Heterocera) and H97LR (Rhopalocera).}
}
\value{
A dataframe with pollinator body size as dry weight (mg) is returned for each specimen from selected equation.
}
\description{
Calculates dry body weight (mg) using head width (mm) from Hodar (1997).
}
\examples{
headwidthsize(HW=c(10,5,2), Eq = c("H97DB"))
}
\references{
Kendall et al. (2018)  Pollinator size and its consequences: Predictive allometry for pollinating insects. <doi:10.1101/397604>

Hodar, J. A. (1997). The use of regresion equations for the estimation of prey length and biomass in diet studies of insectivore vertebrates. Miscellania Zoologica, 20(2), 1-10.
}
