% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crosstab.R
\name{crosstab}
\alias{crosstab}
\title{weighted crosstabs}
\usage{
crosstab(
  df,
  x,
  y,
  weight,
  remove = "",
  n = TRUE,
  pct_type = "row",
  format = "wide"
)
}
\arguments{
\item{df}{The data source}

\item{x}{The independent variable}

\item{y}{The dependent variable}

\item{weight}{The weighting variable}

\item{remove}{An optional character vector of values to remove from final table (e.g. "refused").
This will not affect any calculations made. The vector is not case-sensitive.}

\item{n}{logical, if TRUE numeric totals are included. They are included in a separate column for row and cell
percentages, but in a separate row for wide format column percentages.}

\item{pct_type}{Controls the kind of percentage values returned. One of "row," "cell," or "column."}

\item{format}{one of "long" or "wide"}
}
\value{
a tibble
}
\description{
\code{crosstab} returns a tibble containing a weighted crosstab of two variables
}
\details{
Options  include row, column, or cell percentages. The tibble can be in long or wide format.
}
\examples{
crosstab(df = illinois, x = voter, y = raceethnic, weight = weight)
crosstab(df = illinois, x = voter, y = raceethnic, weight = weight, n = FALSE)
}
